package zio.aws.iotthingsgraph.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{
  NextToken,
  ResourceArn,
  MaxResults
}
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(
    maxResults: Option[MaxResults] = None,
    resourceArn: ResourceArn,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.ListTagsForResourceRequest =
      zio.aws.iotthingsgraph.model.ListTagsForResourceRequest(
        maxResults.map(value => value),
        resourceArn,
        nextToken.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def resourceArn: ResourceArn
    def nextToken: Option[NextToken]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceRequest
  ) extends zio.aws.iotthingsgraph.model.ListTagsForResourceRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iotthingsgraph.model.primitives.MaxResults(value))
    override val resourceArn: ResourceArn =
      zio.aws.iotthingsgraph.model.primitives.ResourceArn(impl.resourceArn())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotthingsgraph.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceRequest
  ): zio.aws.iotthingsgraph.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
