package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{
  DeprecateExistingEntities,
  SyncWithPublicNamespace
}
import scala.jdk.CollectionConverters._
final case class UploadEntityDefinitionsRequest(
    document: Option[zio.aws.iotthingsgraph.model.DefinitionDocument] = None,
    syncWithPublicNamespace: Option[SyncWithPublicNamespace] = None,
    deprecateExistingEntities: Option[DeprecateExistingEntities] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.UploadEntityDefinitionsRequest = {
    import UploadEntityDefinitionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.UploadEntityDefinitionsRequest
      .builder()
      .optionallyWith(document.map(value => value.buildAwsValue()))(_.document)
      .optionallyWith(
        syncWithPublicNamespace.map(value =>
          SyncWithPublicNamespace.unwrap(value): java.lang.Boolean
        )
      )(_.syncWithPublicNamespace)
      .optionallyWith(
        deprecateExistingEntities.map(value =>
          DeprecateExistingEntities.unwrap(value): java.lang.Boolean
        )
      )(_.deprecateExistingEntities)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.UploadEntityDefinitionsRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.UploadEntityDefinitionsRequest
      .wrap(buildAwsValue())
}
object UploadEntityDefinitionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.UploadEntityDefinitionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotthingsgraph.model.UploadEntityDefinitionsRequest =
      zio.aws.iotthingsgraph.model.UploadEntityDefinitionsRequest(
        document.map(value => value.asEditable),
        syncWithPublicNamespace.map(value => value),
        deprecateExistingEntities.map(value => value)
      )
    def document
        : Option[zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly]
    def syncWithPublicNamespace: Option[SyncWithPublicNamespace]
    def deprecateExistingEntities: Option[DeprecateExistingEntities]
    def getDocument: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly
    ] = AwsError.unwrapOptionField("document", document)
    def getSyncWithPublicNamespace
        : ZIO[Any, AwsError, SyncWithPublicNamespace] = AwsError
      .unwrapOptionField("syncWithPublicNamespace", syncWithPublicNamespace)
    def getDeprecateExistingEntities
        : ZIO[Any, AwsError, DeprecateExistingEntities] = AwsError
      .unwrapOptionField("deprecateExistingEntities", deprecateExistingEntities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.UploadEntityDefinitionsRequest
  ) extends zio.aws.iotthingsgraph.model.UploadEntityDefinitionsRequest.ReadOnly {
    override val document
        : Option[zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly] =
      scala
        .Option(impl.document())
        .map(value =>
          zio.aws.iotthingsgraph.model.DefinitionDocument.wrap(value)
        )
    override val syncWithPublicNamespace: Option[SyncWithPublicNamespace] =
      scala
        .Option(impl.syncWithPublicNamespace())
        .map(value =>
          zio.aws.iotthingsgraph.model.primitives.SyncWithPublicNamespace(value)
        )
    override val deprecateExistingEntities: Option[DeprecateExistingEntities] =
      scala
        .Option(impl.deprecateExistingEntities())
        .map(value =>
          zio.aws.iotthingsgraph.model.primitives
            .DeprecateExistingEntities(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.UploadEntityDefinitionsRequest
  ): zio.aws.iotthingsgraph.model.UploadEntityDefinitionsRequest.ReadOnly =
    new Wrapper(impl)
}
