package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.Version
import scala.jdk.CollectionConverters._
final case class CreateFlowTemplateRequest(
    definition: zio.aws.iotthingsgraph.model.DefinitionDocument,
    compatibleNamespaceVersion: Option[Version] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateRequest = {
    import CreateFlowTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateRequest
      .builder()
      .definition(definition.buildAwsValue())
      .optionallyWith(
        compatibleNamespaceVersion.map(value =>
          Version.unwrap(value): java.lang.Long
        )
      )(_.compatibleNamespaceVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.CreateFlowTemplateRequest.ReadOnly =
    zio.aws.iotthingsgraph.model.CreateFlowTemplateRequest.wrap(buildAwsValue())
}
object CreateFlowTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.CreateFlowTemplateRequest =
      zio.aws.iotthingsgraph.model.CreateFlowTemplateRequest(
        definition.asEditable,
        compatibleNamespaceVersion.map(value => value)
      )
    def definition: zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly
    def compatibleNamespaceVersion: Option[Version]
    def getDefinition: ZIO[
      Any,
      Nothing,
      zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly
    ] = ZIO.succeed(definition)
    def getCompatibleNamespaceVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField(
        "compatibleNamespaceVersion",
        compatibleNamespaceVersion
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateRequest
  ) extends zio.aws.iotthingsgraph.model.CreateFlowTemplateRequest.ReadOnly {
    override val definition
        : zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly =
      zio.aws.iotthingsgraph.model.DefinitionDocument.wrap(impl.definition())
    override val compatibleNamespaceVersion: Option[Version] = scala
      .Option(impl.compatibleNamespaceVersion())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateRequest
  ): zio.aws.iotthingsgraph.model.CreateFlowTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
