package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetSystemInstanceResponse(
    description: Option[
      zio.aws.iotthingsgraph.model.SystemInstanceDescription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceResponse = {
    import GetSystemInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceResponse
      .builder()
      .optionallyWith(description.map(value => value.buildAwsValue()))(
        _.description
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotthingsgraph.model.GetSystemInstanceResponse.ReadOnly =
    zio.aws.iotthingsgraph.model.GetSystemInstanceResponse.wrap(buildAwsValue())
}
object GetSystemInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.GetSystemInstanceResponse =
      zio.aws.iotthingsgraph.model
        .GetSystemInstanceResponse(description.map(value => value.asEditable))
    def description: Option[
      zio.aws.iotthingsgraph.model.SystemInstanceDescription.ReadOnly
    ]
    def getDescription: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.SystemInstanceDescription.ReadOnly
    ] = AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceResponse
  ) extends zio.aws.iotthingsgraph.model.GetSystemInstanceResponse.ReadOnly {
    override val description: Option[
      zio.aws.iotthingsgraph.model.SystemInstanceDescription.ReadOnly
    ] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.iotthingsgraph.model.SystemInstanceDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceResponse
  ): zio.aws.iotthingsgraph.model.GetSystemInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
