package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.SystemInstanceFilterValue
import scala.jdk.CollectionConverters._
final case class SystemInstanceFilter(
    name: Option[zio.aws.iotthingsgraph.model.SystemInstanceFilterName] = None,
    value: Option[Iterable[SystemInstanceFilterValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceFilter = {
    import SystemInstanceFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceFilter
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        value.map(value =>
          value.map { item =>
            SystemInstanceFilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.SystemInstanceFilter.ReadOnly =
    zio.aws.iotthingsgraph.model.SystemInstanceFilter.wrap(buildAwsValue())
}
object SystemInstanceFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.SystemInstanceFilter =
      zio.aws.iotthingsgraph.model.SystemInstanceFilter(
        name.map(value => value),
        value.map(value => value)
      )
    def name: Option[zio.aws.iotthingsgraph.model.SystemInstanceFilterName]
    def value: Option[List[SystemInstanceFilterValue]]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.SystemInstanceFilterName
    ] = AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, List[SystemInstanceFilterValue]] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceFilter
  ) extends zio.aws.iotthingsgraph.model.SystemInstanceFilter.ReadOnly {
    override val name
        : Option[zio.aws.iotthingsgraph.model.SystemInstanceFilterName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.iotthingsgraph.model.SystemInstanceFilterName.wrap(value)
      )
    override val value: Option[List[SystemInstanceFilterValue]] = scala
      .Option(impl.value())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotthingsgraph.model.primitives
            .SystemInstanceFilterValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceFilter
  ): zio.aws.iotthingsgraph.model.SystemInstanceFilter.ReadOnly = new Wrapper(
    impl
  )
}
