package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{
  Urn,
  Timestamp,
  GreengrassGroupVersionId,
  Arn,
  GroupName,
  GreengrassGroupId
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class SystemInstanceSummary(
    id: Option[Urn] = None,
    arn: Option[Arn] = None,
    status: Option[
      zio.aws.iotthingsgraph.model.SystemInstanceDeploymentStatus
    ] = None,
    target: Option[zio.aws.iotthingsgraph.model.DeploymentTarget] = None,
    greengrassGroupName: Option[GroupName] = None,
    createdAt: Option[Timestamp] = None,
    updatedAt: Option[Timestamp] = None,
    greengrassGroupId: Option[GreengrassGroupId] = None,
    greengrassGroupVersionId: Option[GreengrassGroupVersionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceSummary = {
    import SystemInstanceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceSummary
      .builder()
      .optionallyWith(id.map(value => Urn.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(target.map(value => value.unwrap))(_.target)
      .optionallyWith(
        greengrassGroupName.map(value =>
          GroupName.unwrap(value): java.lang.String
        )
      )(_.greengrassGroupName)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        greengrassGroupId.map(value =>
          GreengrassGroupId.unwrap(value): java.lang.String
        )
      )(_.greengrassGroupId)
      .optionallyWith(
        greengrassGroupVersionId.map(value =>
          GreengrassGroupVersionId.unwrap(value): java.lang.String
        )
      )(_.greengrassGroupVersionId)
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly =
    zio.aws.iotthingsgraph.model.SystemInstanceSummary.wrap(buildAwsValue())
}
object SystemInstanceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.SystemInstanceSummary =
      zio.aws.iotthingsgraph.model.SystemInstanceSummary(
        id.map(value => value),
        arn.map(value => value),
        status.map(value => value),
        target.map(value => value),
        greengrassGroupName.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value),
        greengrassGroupId.map(value => value),
        greengrassGroupVersionId.map(value => value)
      )
    def id: Option[Urn]
    def arn: Option[Arn]
    def status
        : Option[zio.aws.iotthingsgraph.model.SystemInstanceDeploymentStatus]
    def target: Option[zio.aws.iotthingsgraph.model.DeploymentTarget]
    def greengrassGroupName: Option[GroupName]
    def createdAt: Option[Timestamp]
    def updatedAt: Option[Timestamp]
    def greengrassGroupId: Option[GreengrassGroupId]
    def greengrassGroupVersionId: Option[GreengrassGroupVersionId]
    def getId: ZIO[Any, AwsError, Urn] = AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.SystemInstanceDeploymentStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getTarget
        : ZIO[Any, AwsError, zio.aws.iotthingsgraph.model.DeploymentTarget] =
      AwsError.unwrapOptionField("target", target)
    def getGreengrassGroupName: ZIO[Any, AwsError, GroupName] =
      AwsError.unwrapOptionField("greengrassGroupName", greengrassGroupName)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getGreengrassGroupId: ZIO[Any, AwsError, GreengrassGroupId] =
      AwsError.unwrapOptionField("greengrassGroupId", greengrassGroupId)
    def getGreengrassGroupVersionId
        : ZIO[Any, AwsError, GreengrassGroupVersionId] = AwsError
      .unwrapOptionField("greengrassGroupVersionId", greengrassGroupVersionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceSummary
  ) extends zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly {
    override val id: Option[Urn] = scala
      .Option(impl.id())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Urn(value))
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Arn(value))
    override val status
        : Option[zio.aws.iotthingsgraph.model.SystemInstanceDeploymentStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          zio.aws.iotthingsgraph.model.SystemInstanceDeploymentStatus
            .wrap(value)
        )
    override val target: Option[zio.aws.iotthingsgraph.model.DeploymentTarget] =
      scala
        .Option(impl.target())
        .map(value => zio.aws.iotthingsgraph.model.DeploymentTarget.wrap(value))
    override val greengrassGroupName: Option[GroupName] = scala
      .Option(impl.greengrassGroupName())
      .map(value => zio.aws.iotthingsgraph.model.primitives.GroupName(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Timestamp(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Timestamp(value))
    override val greengrassGroupId: Option[GreengrassGroupId] = scala
      .Option(impl.greengrassGroupId())
      .map(value =>
        zio.aws.iotthingsgraph.model.primitives.GreengrassGroupId(value)
      )
    override val greengrassGroupVersionId: Option[GreengrassGroupVersionId] =
      scala
        .Option(impl.greengrassGroupVersionId())
        .map(value =>
          zio.aws.iotthingsgraph.model.primitives
            .GreengrassGroupVersionId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceSummary
  ): zio.aws.iotthingsgraph.model.SystemInstanceSummary.ReadOnly = new Wrapper(
    impl
  )
}
