package zio.aws.iotthingsgraph.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotthingsgraph.model.primitives.{Timestamp, Arn, Urn}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class EntityDescription(
    id: Option[Urn] = None,
    arn: Option[Arn] = None,
    `type`: Option[zio.aws.iotthingsgraph.model.EntityType] = None,
    createdAt: Option[Timestamp] = None,
    definition: Option[zio.aws.iotthingsgraph.model.DefinitionDocument] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotthingsgraph.model.EntityDescription = {
    import EntityDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotthingsgraph.model.EntityDescription
      .builder()
      .optionallyWith(id.map(value => Urn.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(definition.map(value => value.buildAwsValue()))(
        _.definition
      )
      .build()
  }
  def asReadOnly: zio.aws.iotthingsgraph.model.EntityDescription.ReadOnly =
    zio.aws.iotthingsgraph.model.EntityDescription.wrap(buildAwsValue())
}
object EntityDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotthingsgraph.model.EntityDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotthingsgraph.model.EntityDescription =
      zio.aws.iotthingsgraph.model.EntityDescription(
        id.map(value => value),
        arn.map(value => value),
        `type`.map(value => value),
        createdAt.map(value => value),
        definition.map(value => value.asEditable)
      )
    def id: Option[Urn]
    def arn: Option[Arn]
    def `type`: Option[zio.aws.iotthingsgraph.model.EntityType]
    def createdAt: Option[Timestamp]
    def definition
        : Option[zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly]
    def getId: ZIO[Any, AwsError, Urn] = AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getType: ZIO[Any, AwsError, zio.aws.iotthingsgraph.model.EntityType] =
      AwsError.unwrapOptionField("type", `type`)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly
    ] = AwsError.unwrapOptionField("definition", definition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.EntityDescription
  ) extends zio.aws.iotthingsgraph.model.EntityDescription.ReadOnly {
    override val id: Option[Urn] = scala
      .Option(impl.id())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Urn(value))
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Arn(value))
    override val `type`: Option[zio.aws.iotthingsgraph.model.EntityType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.iotthingsgraph.model.EntityType.wrap(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.iotthingsgraph.model.primitives.Timestamp(value))
    override val definition
        : Option[zio.aws.iotthingsgraph.model.DefinitionDocument.ReadOnly] =
      scala
        .Option(impl.definition())
        .map(value =>
          zio.aws.iotthingsgraph.model.DefinitionDocument.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotthingsgraph.model.EntityDescription
  ): zio.aws.iotthingsgraph.model.EntityDescription.ReadOnly = new Wrapper(impl)
}
