package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{
  TagValue,
  TagKey,
  AmazonResourceName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: AmazonResourceName,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.TagResourceRequest
      .builder()
      .resourceArn(AmazonResourceName.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.TagResourceRequest.ReadOnly =
    zio.aws.iotsitewise.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.TagResourceRequest =
      zio.aws.iotsitewise.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: AmazonResourceName
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.TagResourceRequest
  ) extends zio.aws.iotsitewise.model.TagResourceRequest.ReadOnly {
    override val resourceArn: AmazonResourceName =
      zio.aws.iotsitewise.model.primitives
        .AmazonResourceName(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.iotsitewise.model.primitives
          .TagKey(key) -> zio.aws.iotsitewise.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.TagResourceRequest
  ): zio.aws.iotsitewise.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
