package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Measurement(
    processingConfig: Optional[
      zio.aws.iotsitewise.model.MeasurementProcessingConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.Measurement = {
    import Measurement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.Measurement
      .builder()
      .optionallyWith(processingConfig.map(value => value.buildAwsValue()))(
        _.processingConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.Measurement.ReadOnly =
    zio.aws.iotsitewise.model.Measurement.wrap(buildAwsValue())
}
object Measurement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.Measurement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.Measurement =
      zio.aws.iotsitewise.model
        .Measurement(processingConfig.map(value => value.asEditable))
    def processingConfig: Optional[
      zio.aws.iotsitewise.model.MeasurementProcessingConfig.ReadOnly
    ]
    def getProcessingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.MeasurementProcessingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("processingConfig", processingConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.Measurement
  ) extends zio.aws.iotsitewise.model.Measurement.ReadOnly {
    override val processingConfig: Optional[
      zio.aws.iotsitewise.model.MeasurementProcessingConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.processingConfig())
      .map(value =>
        zio.aws.iotsitewise.model.MeasurementProcessingConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.Measurement
  ): zio.aws.iotsitewise.model.Measurement.ReadOnly = new Wrapper(impl)
}
