package zio.aws.iotsitewise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{
  PropertyAlias,
  ID,
  MaxResults,
  NextToken
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTimeSeriesRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    assetId: Optional[ID] = Optional.Absent,
    aliasPrefix: Optional[PropertyAlias] = Optional.Absent,
    timeSeriesType: Optional[zio.aws.iotsitewise.model.ListTimeSeriesType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest = {
    import ListTimeSeriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(assetId.map(value => ID.unwrap(value): java.lang.String))(
        _.assetId
      )
      .optionallyWith(
        aliasPrefix.map(value => PropertyAlias.unwrap(value): java.lang.String)
      )(_.aliasPrefix)
      .optionallyWith(timeSeriesType.map(value => value.unwrap))(
        _.timeSeriesType
      )
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ListTimeSeriesRequest.ReadOnly =
    zio.aws.iotsitewise.model.ListTimeSeriesRequest.wrap(buildAwsValue())
}
object ListTimeSeriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListTimeSeriesRequest =
      zio.aws.iotsitewise.model.ListTimeSeriesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        assetId.map(value => value),
        aliasPrefix.map(value => value),
        timeSeriesType.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def assetId: Optional[ID]
    def aliasPrefix: Optional[PropertyAlias]
    def timeSeriesType: Optional[zio.aws.iotsitewise.model.ListTimeSeriesType]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getAssetId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("assetId", assetId)
    def getAliasPrefix: ZIO[Any, AwsError, PropertyAlias] =
      AwsError.unwrapOptionField("aliasPrefix", aliasPrefix)
    def getTimeSeriesType
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.ListTimeSeriesType] =
      AwsError.unwrapOptionField("timeSeriesType", timeSeriesType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest
  ) extends zio.aws.iotsitewise.model.ListTimeSeriesRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotsitewise.model.primitives.MaxResults(value))
    override val assetId: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.assetId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val aliasPrefix: Optional[PropertyAlias] = zio.aws.core.internal
      .optionalFromNullable(impl.aliasPrefix())
      .map(value => zio.aws.iotsitewise.model.primitives.PropertyAlias(value))
    override val timeSeriesType
        : Optional[zio.aws.iotsitewise.model.ListTimeSeriesType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeSeriesType())
        .map(value => zio.aws.iotsitewise.model.ListTimeSeriesType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest
  ): zio.aws.iotsitewise.model.ListTimeSeriesRequest.ReadOnly = new Wrapper(
    impl
  )
}
