package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAssociatedAssetsResponse(
    assetSummaries: Iterable[zio.aws.iotsitewise.model.AssociatedAssetsSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsResponse = {
    import ListAssociatedAssetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsResponse
      .builder()
      .assetSummaries(assetSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.ListAssociatedAssetsResponse.ReadOnly =
    zio.aws.iotsitewise.model.ListAssociatedAssetsResponse.wrap(buildAwsValue())
}
object ListAssociatedAssetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListAssociatedAssetsResponse =
      zio.aws.iotsitewise.model.ListAssociatedAssetsResponse(
        assetSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def assetSummaries
        : List[zio.aws.iotsitewise.model.AssociatedAssetsSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getAssetSummaries: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.AssociatedAssetsSummary.ReadOnly
    ]] = ZIO.succeed(assetSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsResponse
  ) extends zio.aws.iotsitewise.model.ListAssociatedAssetsResponse.ReadOnly {
    override val assetSummaries
        : List[zio.aws.iotsitewise.model.AssociatedAssetsSummary.ReadOnly] =
      impl
        .assetSummaries()
        .asScala
        .map { item =>
          zio.aws.iotsitewise.model.AssociatedAssetsSummary.wrap(item)
        }
        .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsResponse
  ): zio.aws.iotsitewise.model.ListAssociatedAssetsResponse.ReadOnly =
    new Wrapper(impl)
}
