package zio.aws.iotsitewise.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{
  NextToken,
  AssetPropertyAlias,
  Timestamp,
  GetAssetPropertyValueAggregatesMaxResults,
  Resolution,
  ID
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetAssetPropertyAggregatesRequest(
    assetId: Optional[ID] = Optional.Absent,
    propertyId: Optional[ID] = Optional.Absent,
    propertyAlias: Optional[AssetPropertyAlias] = Optional.Absent,
    aggregateTypes: Iterable[zio.aws.iotsitewise.model.AggregateType],
    resolution: Resolution,
    qualities: Optional[Iterable[zio.aws.iotsitewise.model.Quality]] =
      Optional.Absent,
    startDate: Timestamp,
    endDate: Timestamp,
    timeOrdering: Optional[zio.aws.iotsitewise.model.TimeOrdering] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[GetAssetPropertyValueAggregatesMaxResults] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest = {
    import GetAssetPropertyAggregatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest
      .builder()
      .optionallyWith(assetId.map(value => ID.unwrap(value): java.lang.String))(
        _.assetId
      )
      .optionallyWith(
        propertyId.map(value => ID.unwrap(value): java.lang.String)
      )(_.propertyId)
      .optionallyWith(
        propertyAlias.map(value =>
          AssetPropertyAlias.unwrap(value): java.lang.String
        )
      )(_.propertyAlias)
      .aggregateTypesWithStrings(aggregateTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .resolution(Resolution.unwrap(resolution): java.lang.String)
      .optionallyWith(
        qualities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.qualitiesWithStrings)
      .startDate(Timestamp.unwrap(startDate): Instant)
      .endDate(Timestamp.unwrap(endDate): Instant)
      .optionallyWith(timeOrdering.map(value => value.unwrap))(_.timeOrdering)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          GetAssetPropertyValueAggregatesMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.GetAssetPropertyAggregatesRequest.ReadOnly =
    zio.aws.iotsitewise.model.GetAssetPropertyAggregatesRequest
      .wrap(buildAwsValue())
}
object GetAssetPropertyAggregatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.GetAssetPropertyAggregatesRequest =
      zio.aws.iotsitewise.model.GetAssetPropertyAggregatesRequest(
        assetId.map(value => value),
        propertyId.map(value => value),
        propertyAlias.map(value => value),
        aggregateTypes,
        resolution,
        qualities.map(value => value),
        startDate,
        endDate,
        timeOrdering.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def assetId: Optional[ID]
    def propertyId: Optional[ID]
    def propertyAlias: Optional[AssetPropertyAlias]
    def aggregateTypes: List[zio.aws.iotsitewise.model.AggregateType]
    def resolution: Resolution
    def qualities: Optional[List[zio.aws.iotsitewise.model.Quality]]
    def startDate: Timestamp
    def endDate: Timestamp
    def timeOrdering: Optional[zio.aws.iotsitewise.model.TimeOrdering]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[GetAssetPropertyValueAggregatesMaxResults]
    def getAssetId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("assetId", assetId)
    def getPropertyId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("propertyId", propertyId)
    def getPropertyAlias: ZIO[Any, AwsError, AssetPropertyAlias] =
      AwsError.unwrapOptionField("propertyAlias", propertyAlias)
    def getAggregateTypes
        : ZIO[Any, Nothing, List[zio.aws.iotsitewise.model.AggregateType]] =
      ZIO.succeed(aggregateTypes)
    def getResolution: ZIO[Any, Nothing, Resolution] = ZIO.succeed(resolution)
    def getQualities
        : ZIO[Any, AwsError, List[zio.aws.iotsitewise.model.Quality]] =
      AwsError.unwrapOptionField("qualities", qualities)
    def getStartDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startDate)
    def getEndDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endDate)
    def getTimeOrdering
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.TimeOrdering] =
      AwsError.unwrapOptionField("timeOrdering", timeOrdering)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, GetAssetPropertyValueAggregatesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest
  ) extends zio.aws.iotsitewise.model.GetAssetPropertyAggregatesRequest.ReadOnly {
    override val assetId: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.assetId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val propertyId: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val propertyAlias: Optional[AssetPropertyAlias] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propertyAlias())
        .map(value =>
          zio.aws.iotsitewise.model.primitives.AssetPropertyAlias(value)
        )
    override val aggregateTypes: List[zio.aws.iotsitewise.model.AggregateType] =
      impl
        .aggregateTypes()
        .asScala
        .map { item =>
          zio.aws.iotsitewise.model.AggregateType.wrap(item)
        }
        .toList
    override val resolution: Resolution =
      zio.aws.iotsitewise.model.primitives.Resolution(impl.resolution())
    override val qualities: Optional[List[zio.aws.iotsitewise.model.Quality]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.qualities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotsitewise.model.Quality.wrap(item)
          }.toList
        )
    override val startDate: Timestamp =
      zio.aws.iotsitewise.model.primitives.Timestamp(impl.startDate())
    override val endDate: Timestamp =
      zio.aws.iotsitewise.model.primitives.Timestamp(impl.endDate())
    override val timeOrdering
        : Optional[zio.aws.iotsitewise.model.TimeOrdering] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeOrdering())
        .map(value => zio.aws.iotsitewise.model.TimeOrdering.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
    override val maxResults
        : Optional[GetAssetPropertyValueAggregatesMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.iotsitewise.model.primitives
            .GetAssetPropertyValueAggregatesMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest
  ): zio.aws.iotsitewise.model.GetAssetPropertyAggregatesRequest.ReadOnly =
    new Wrapper(impl)
}
