package zio.aws.iotsitewise.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{
  Timestamp,
  Description,
  Name,
  ARN,
  ID
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeProjectResponse(
    projectId: ID,
    projectArn: ARN,
    projectName: Name,
    portalId: ID,
    projectDescription: Optional[Description] = Optional.Absent,
    projectCreationDate: Timestamp,
    projectLastUpdateDate: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeProjectResponse = {
    import DescribeProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeProjectResponse
      .builder()
      .projectId(ID.unwrap(projectId): java.lang.String)
      .projectArn(ARN.unwrap(projectArn): java.lang.String)
      .projectName(Name.unwrap(projectName): java.lang.String)
      .portalId(ID.unwrap(portalId): java.lang.String)
      .optionallyWith(
        projectDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.projectDescription)
      .projectCreationDate(Timestamp.unwrap(projectCreationDate): Instant)
      .projectLastUpdateDate(Timestamp.unwrap(projectLastUpdateDate): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DescribeProjectResponse.ReadOnly =
    zio.aws.iotsitewise.model.DescribeProjectResponse.wrap(buildAwsValue())
}
object DescribeProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DescribeProjectResponse =
      zio.aws.iotsitewise.model.DescribeProjectResponse(
        projectId,
        projectArn,
        projectName,
        portalId,
        projectDescription.map(value => value),
        projectCreationDate,
        projectLastUpdateDate
      )
    def projectId: ID
    def projectArn: ARN
    def projectName: Name
    def portalId: ID
    def projectDescription: Optional[Description]
    def projectCreationDate: Timestamp
    def projectLastUpdateDate: Timestamp
    def getProjectId: ZIO[Any, Nothing, ID] = ZIO.succeed(projectId)
    def getProjectArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(projectArn)
    def getProjectName: ZIO[Any, Nothing, Name] = ZIO.succeed(projectName)
    def getPortalId: ZIO[Any, Nothing, ID] = ZIO.succeed(portalId)
    def getProjectDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("projectDescription", projectDescription)
    def getProjectCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(projectCreationDate)
    def getProjectLastUpdateDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(projectLastUpdateDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeProjectResponse
  ) extends zio.aws.iotsitewise.model.DescribeProjectResponse.ReadOnly {
    override val projectId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.projectId())
    override val projectArn: ARN =
      zio.aws.iotsitewise.model.primitives.ARN(impl.projectArn())
    override val projectName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.projectName())
    override val portalId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.portalId())
    override val projectDescription: Optional[Description] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projectDescription())
        .map(value => zio.aws.iotsitewise.model.primitives.Description(value))
    override val projectCreationDate: Timestamp =
      zio.aws.iotsitewise.model.primitives.Timestamp(impl.projectCreationDate())
    override val projectLastUpdateDate: Timestamp =
      zio.aws.iotsitewise.model.primitives
        .Timestamp(impl.projectLastUpdateDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeProjectResponse
  ): zio.aws.iotsitewise.model.DescribeProjectResponse.ReadOnly = new Wrapper(
    impl
  )
}
