package zio.aws.iotsitewise.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{
  Timestamp,
  Description,
  Name,
  ARN,
  ID
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeAssetModelResponse(
    assetModelId: ID,
    assetModelArn: ARN,
    assetModelName: Name,
    assetModelDescription: Description,
    assetModelProperties: Iterable[
      zio.aws.iotsitewise.model.AssetModelProperty
    ],
    assetModelHierarchies: Iterable[
      zio.aws.iotsitewise.model.AssetModelHierarchy
    ],
    assetModelCompositeModels: Optional[
      Iterable[zio.aws.iotsitewise.model.AssetModelCompositeModel]
    ] = Optional.Absent,
    assetModelCreationDate: Timestamp,
    assetModelLastUpdateDate: Timestamp,
    assetModelStatus: zio.aws.iotsitewise.model.AssetModelStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelResponse = {
    import DescribeAssetModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelResponse
      .builder()
      .assetModelId(ID.unwrap(assetModelId): java.lang.String)
      .assetModelArn(ARN.unwrap(assetModelArn): java.lang.String)
      .assetModelName(Name.unwrap(assetModelName): java.lang.String)
      .assetModelDescription(
        Description.unwrap(assetModelDescription): java.lang.String
      )
      .assetModelProperties(assetModelProperties.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .assetModelHierarchies(assetModelHierarchies.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        assetModelCompositeModels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assetModelCompositeModels)
      .assetModelCreationDate(Timestamp.unwrap(assetModelCreationDate): Instant)
      .assetModelLastUpdateDate(
        Timestamp.unwrap(assetModelLastUpdateDate): Instant
      )
      .assetModelStatus(assetModelStatus.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.DescribeAssetModelResponse.ReadOnly =
    zio.aws.iotsitewise.model.DescribeAssetModelResponse.wrap(buildAwsValue())
}
object DescribeAssetModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DescribeAssetModelResponse =
      zio.aws.iotsitewise.model.DescribeAssetModelResponse(
        assetModelId,
        assetModelArn,
        assetModelName,
        assetModelDescription,
        assetModelProperties.map { item =>
          item.asEditable
        },
        assetModelHierarchies.map { item =>
          item.asEditable
        },
        assetModelCompositeModels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        assetModelCreationDate,
        assetModelLastUpdateDate,
        assetModelStatus.asEditable
      )
    def assetModelId: ID
    def assetModelArn: ARN
    def assetModelName: Name
    def assetModelDescription: Description
    def assetModelProperties
        : List[zio.aws.iotsitewise.model.AssetModelProperty.ReadOnly]
    def assetModelHierarchies
        : List[zio.aws.iotsitewise.model.AssetModelHierarchy.ReadOnly]
    def assetModelCompositeModels: Optional[
      List[zio.aws.iotsitewise.model.AssetModelCompositeModel.ReadOnly]
    ]
    def assetModelCreationDate: Timestamp
    def assetModelLastUpdateDate: Timestamp
    def assetModelStatus: zio.aws.iotsitewise.model.AssetModelStatus.ReadOnly
    def getAssetModelId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetModelId)
    def getAssetModelArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(assetModelArn)
    def getAssetModelName: ZIO[Any, Nothing, Name] = ZIO.succeed(assetModelName)
    def getAssetModelDescription: ZIO[Any, Nothing, Description] =
      ZIO.succeed(assetModelDescription)
    def getAssetModelProperties: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.AssetModelProperty.ReadOnly
    ]] = ZIO.succeed(assetModelProperties)
    def getAssetModelHierarchies: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.AssetModelHierarchy.ReadOnly
    ]] = ZIO.succeed(assetModelHierarchies)
    def getAssetModelCompositeModels: ZIO[Any, AwsError, List[
      zio.aws.iotsitewise.model.AssetModelCompositeModel.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "assetModelCompositeModels",
      assetModelCompositeModels
    )
    def getAssetModelCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(assetModelCreationDate)
    def getAssetModelLastUpdateDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(assetModelLastUpdateDate)
    def getAssetModelStatus: ZIO[
      Any,
      Nothing,
      zio.aws.iotsitewise.model.AssetModelStatus.ReadOnly
    ] = ZIO.succeed(assetModelStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelResponse
  ) extends zio.aws.iotsitewise.model.DescribeAssetModelResponse.ReadOnly {
    override val assetModelId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetModelId())
    override val assetModelArn: ARN =
      zio.aws.iotsitewise.model.primitives.ARN(impl.assetModelArn())
    override val assetModelName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.assetModelName())
    override val assetModelDescription: Description =
      zio.aws.iotsitewise.model.primitives
        .Description(impl.assetModelDescription())
    override val assetModelProperties
        : List[zio.aws.iotsitewise.model.AssetModelProperty.ReadOnly] = impl
      .assetModelProperties()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.AssetModelProperty.wrap(item)
      }
      .toList
    override val assetModelHierarchies
        : List[zio.aws.iotsitewise.model.AssetModelHierarchy.ReadOnly] = impl
      .assetModelHierarchies()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.AssetModelHierarchy.wrap(item)
      }
      .toList
    override val assetModelCompositeModels: Optional[
      List[zio.aws.iotsitewise.model.AssetModelCompositeModel.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.assetModelCompositeModels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotsitewise.model.AssetModelCompositeModel.wrap(item)
        }.toList
      )
    override val assetModelCreationDate: Timestamp =
      zio.aws.iotsitewise.model.primitives
        .Timestamp(impl.assetModelCreationDate())
    override val assetModelLastUpdateDate: Timestamp =
      zio.aws.iotsitewise.model.primitives
        .Timestamp(impl.assetModelLastUpdateDate())
    override val assetModelStatus
        : zio.aws.iotsitewise.model.AssetModelStatus.ReadOnly =
      zio.aws.iotsitewise.model.AssetModelStatus.wrap(impl.assetModelStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelResponse
  ): zio.aws.iotsitewise.model.DescribeAssetModelResponse.ReadOnly =
    new Wrapper(impl)
}
