package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ARN, ID}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateProjectResponse(projectId: ID, projectArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.CreateProjectResponse = {
    import CreateProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.CreateProjectResponse
      .builder()
      .projectId(ID.unwrap(projectId): java.lang.String)
      .projectArn(ARN.unwrap(projectArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.CreateProjectResponse.ReadOnly =
    zio.aws.iotsitewise.model.CreateProjectResponse.wrap(buildAwsValue())
}
object CreateProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.CreateProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.CreateProjectResponse =
      zio.aws.iotsitewise.model.CreateProjectResponse(projectId, projectArn)
    def projectId: ID
    def projectArn: ARN
    def getProjectId: ZIO[Any, Nothing, ID] = ZIO.succeed(projectId)
    def getProjectArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(projectArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateProjectResponse
  ) extends zio.aws.iotsitewise.model.CreateProjectResponse.ReadOnly {
    override val projectId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.projectId())
    override val projectArn: ARN =
      zio.aws.iotsitewise.model.primitives.ARN(impl.projectArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateProjectResponse
  ): zio.aws.iotsitewise.model.CreateProjectResponse.ReadOnly = new Wrapper(
    impl
  )
}
