package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.EntryId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchGetAssetPropertyValueHistorySkippedEntry(
    entryId: EntryId,
    completionStatus: zio.aws.iotsitewise.model.BatchEntryCompletionStatus,
    errorInfo: Optional[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorInfo
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistorySkippedEntry = {
    import BatchGetAssetPropertyValueHistorySkippedEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistorySkippedEntry
      .builder()
      .entryId(EntryId.unwrap(entryId): java.lang.String)
      .completionStatus(completionStatus.unwrap)
      .optionallyWith(errorInfo.map(value => value.buildAwsValue()))(
        _.errorInfo
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistorySkippedEntry.ReadOnly =
    zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistorySkippedEntry
      .wrap(buildAwsValue())
}
object BatchGetAssetPropertyValueHistorySkippedEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistorySkippedEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistorySkippedEntry =
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistorySkippedEntry(
        entryId,
        completionStatus,
        errorInfo.map(value => value.asEditable)
      )
    def entryId: EntryId
    def completionStatus: zio.aws.iotsitewise.model.BatchEntryCompletionStatus
    def errorInfo: Optional[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorInfo.ReadOnly
    ]
    def getEntryId: ZIO[Any, Nothing, EntryId] = ZIO.succeed(entryId)
    def getCompletionStatus: ZIO[
      Any,
      Nothing,
      zio.aws.iotsitewise.model.BatchEntryCompletionStatus
    ] = ZIO.succeed(completionStatus)
    def getErrorInfo: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorInfo.ReadOnly
    ] = AwsError.unwrapOptionField("errorInfo", errorInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistorySkippedEntry
  ) extends zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistorySkippedEntry.ReadOnly {
    override val entryId: EntryId =
      zio.aws.iotsitewise.model.primitives.EntryId(impl.entryId())
    override val completionStatus
        : zio.aws.iotsitewise.model.BatchEntryCompletionStatus =
      zio.aws.iotsitewise.model.BatchEntryCompletionStatus
        .wrap(impl.completionStatus())
    override val errorInfo: Optional[
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorInfo.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errorInfo())
      .map(value =>
        zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorInfo
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistorySkippedEntry
  ): zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistorySkippedEntry.ReadOnly =
    new Wrapper(impl)
}
