package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.EntryId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchGetAssetPropertyAggregatesSuccessEntry(
    entryId: EntryId,
    aggregatedValues: Iterable[zio.aws.iotsitewise.model.AggregatedValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesSuccessEntry = {
    import BatchGetAssetPropertyAggregatesSuccessEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesSuccessEntry
      .builder()
      .entryId(EntryId.unwrap(entryId): java.lang.String)
      .aggregatedValues(aggregatedValues.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesSuccessEntry.ReadOnly =
    zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesSuccessEntry
      .wrap(buildAwsValue())
}
object BatchGetAssetPropertyAggregatesSuccessEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesSuccessEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesSuccessEntry =
      zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesSuccessEntry(
        entryId,
        aggregatedValues.map { item =>
          item.asEditable
        }
      )
    def entryId: EntryId
    def aggregatedValues
        : List[zio.aws.iotsitewise.model.AggregatedValue.ReadOnly]
    def getEntryId: ZIO[Any, Nothing, EntryId] = ZIO.succeed(entryId)
    def getAggregatedValues: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.AggregatedValue.ReadOnly
    ]] = ZIO.succeed(aggregatedValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesSuccessEntry
  ) extends zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesSuccessEntry.ReadOnly {
    override val entryId: EntryId =
      zio.aws.iotsitewise.model.primitives.EntryId(impl.entryId())
    override val aggregatedValues
        : List[zio.aws.iotsitewise.model.AggregatedValue.ReadOnly] = impl
      .aggregatedValues()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.AggregatedValue.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesSuccessEntry
  ): zio.aws.iotsitewise.model.BatchGetAssetPropertyAggregatesSuccessEntry.ReadOnly =
    new Wrapper(impl)
}
