package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssetStatus(
    state: zio.aws.iotsitewise.model.AssetState,
    error: Optional[zio.aws.iotsitewise.model.ErrorDetails] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.AssetStatus = {
    import AssetStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.AssetStatus
      .builder()
      .state(state.unwrap)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.AssetStatus.ReadOnly =
    zio.aws.iotsitewise.model.AssetStatus.wrap(buildAwsValue())
}
object AssetStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.AssetStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.AssetStatus =
      zio.aws.iotsitewise.model
        .AssetStatus(state, error.map(value => value.asEditable))
    def state: zio.aws.iotsitewise.model.AssetState
    def error: Optional[zio.aws.iotsitewise.model.ErrorDetails.ReadOnly]
    def getState: ZIO[Any, Nothing, zio.aws.iotsitewise.model.AssetState] =
      ZIO.succeed(state)
    def getError
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.ErrorDetails.ReadOnly] =
      AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetStatus
  ) extends zio.aws.iotsitewise.model.AssetStatus.ReadOnly {
    override val state: zio.aws.iotsitewise.model.AssetState =
      zio.aws.iotsitewise.model.AssetState.wrap(impl.state())
    override val error
        : Optional[zio.aws.iotsitewise.model.ErrorDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.error())
        .map(value => zio.aws.iotsitewise.model.ErrorDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetStatus
  ): zio.aws.iotsitewise.model.AssetStatus.ReadOnly = new Wrapper(impl)
}
