package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters._
sealed trait AssetModelState {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.AssetModelState
}
object AssetModelState {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.AssetModelState
  ): zio.aws.iotsitewise.model.AssetModelState = value match {
    case software.amazon.awssdk.services.iotsitewise.model.AssetModelState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.AssetModelState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.iotsitewise.model.AssetModelState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.iotsitewise.model.AssetModelState.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.iotsitewise.model.AssetModelState.PROPAGATING =>
      val r = PROPAGATING
      r
    case software.amazon.awssdk.services.iotsitewise.model.AssetModelState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.iotsitewise.model.AssetModelState.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsitewise.model.AssetModelState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AssetModelState =
      software.amazon.awssdk.services.iotsitewise.model.AssetModelState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.iotsitewise.model.AssetModelState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AssetModelState =
      software.amazon.awssdk.services.iotsitewise.model.AssetModelState.CREATING
  }
  case object ACTIVE extends zio.aws.iotsitewise.model.AssetModelState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AssetModelState =
      software.amazon.awssdk.services.iotsitewise.model.AssetModelState.ACTIVE
  }
  case object UPDATING extends zio.aws.iotsitewise.model.AssetModelState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AssetModelState =
      software.amazon.awssdk.services.iotsitewise.model.AssetModelState.UPDATING
  }
  case object PROPAGATING extends zio.aws.iotsitewise.model.AssetModelState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AssetModelState =
      software.amazon.awssdk.services.iotsitewise.model.AssetModelState.PROPAGATING
  }
  case object DELETING extends zio.aws.iotsitewise.model.AssetModelState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AssetModelState =
      software.amazon.awssdk.services.iotsitewise.model.AssetModelState.DELETING
  }
  case object FAILED extends zio.aws.iotsitewise.model.AssetModelState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AssetModelState =
      software.amazon.awssdk.services.iotsitewise.model.AssetModelState.FAILED
  }
}
