package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters._
sealed trait IdentityType {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.IdentityType
}
object IdentityType {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.IdentityType
  ): zio.aws.iotsitewise.model.IdentityType = value match {
    case software.amazon.awssdk.services.iotsitewise.model.IdentityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.IdentityType.USER =>
      val r = USER
      r
    case software.amazon.awssdk.services.iotsitewise.model.IdentityType.GROUP =>
      val r = GROUP
      r
    case software.amazon.awssdk.services.iotsitewise.model.IdentityType.IAM =>
      val r = IAM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsitewise.model.IdentityType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.IdentityType =
      software.amazon.awssdk.services.iotsitewise.model.IdentityType.UNKNOWN_TO_SDK_VERSION
  }
  case object USER extends zio.aws.iotsitewise.model.IdentityType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.IdentityType =
      software.amazon.awssdk.services.iotsitewise.model.IdentityType.USER
  }
  case object GROUP extends zio.aws.iotsitewise.model.IdentityType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.IdentityType =
      software.amazon.awssdk.services.iotsitewise.model.IdentityType.GROUP
  }
  case object IAM extends zio.aws.iotsitewise.model.IdentityType {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.IdentityType =
      software.amazon.awssdk.services.iotsitewise.model.IdentityType.IAM
  }
}
