package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.Bucket
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ErrorReportLocation(bucket: Bucket, prefix: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ErrorReportLocation = {
    import ErrorReportLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ErrorReportLocation
      .builder()
      .bucket(Bucket.unwrap(bucket): java.lang.String)
      .prefix(prefix: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ErrorReportLocation.ReadOnly =
    zio.aws.iotsitewise.model.ErrorReportLocation.wrap(buildAwsValue())
}
object ErrorReportLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ErrorReportLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ErrorReportLocation =
      zio.aws.iotsitewise.model.ErrorReportLocation(bucket, prefix)
    def bucket: Bucket
    def prefix: String
    def getBucket: ZIO[Any, Nothing, Bucket] = ZIO.succeed(bucket)
    def getPrefix: ZIO[Any, Nothing, String] = ZIO.succeed(prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ErrorReportLocation
  ) extends zio.aws.iotsitewise.model.ErrorReportLocation.ReadOnly {
    override val bucket: Bucket =
      zio.aws.iotsitewise.model.primitives.Bucket(impl.bucket())
    override val prefix: String = impl.prefix(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ErrorReportLocation
  ): zio.aws.iotsitewise.model.ErrorReportLocation.ReadOnly = new Wrapper(impl)
}
