package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ExcludeProperties, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAssetModelRequest(
    assetModelId: ID,
    excludeProperties: Optional[ExcludeProperties] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelRequest = {
    import DescribeAssetModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelRequest
      .builder()
      .assetModelId(ID.unwrap(assetModelId): java.lang.String)
      .optionallyWith(
        excludeProperties.map(value =>
          ExcludeProperties.unwrap(value): java.lang.Boolean
        )
      )(_.excludeProperties)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DescribeAssetModelRequest.ReadOnly =
    zio.aws.iotsitewise.model.DescribeAssetModelRequest.wrap(buildAwsValue())
}
object DescribeAssetModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DescribeAssetModelRequest =
      zio.aws.iotsitewise.model.DescribeAssetModelRequest(
        assetModelId,
        excludeProperties.map(value => value)
      )
    def assetModelId: ID
    def excludeProperties: Optional[ExcludeProperties]
    def getAssetModelId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetModelId)
    def getExcludeProperties: ZIO[Any, AwsError, ExcludeProperties] =
      AwsError.unwrapOptionField("excludeProperties", excludeProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelRequest
  ) extends zio.aws.iotsitewise.model.DescribeAssetModelRequest.ReadOnly {
    override val assetModelId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetModelId())
    override val excludeProperties: Optional[ExcludeProperties] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludeProperties())
        .map(value =>
          zio.aws.iotsitewise.model.primitives.ExcludeProperties(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelRequest
  ): zio.aws.iotsitewise.model.DescribeAssetModelRequest.ReadOnly = new Wrapper(
    impl
  )
}
