package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{TagValue, TagKey, ClientToken}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAccessPolicyRequest(
    accessPolicyIdentity: zio.aws.iotsitewise.model.Identity,
    accessPolicyResource: zio.aws.iotsitewise.model.Resource,
    accessPolicyPermission: zio.aws.iotsitewise.model.Permission,
    clientToken: Optional[ClientToken] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.CreateAccessPolicyRequest = {
    import CreateAccessPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.CreateAccessPolicyRequest
      .builder()
      .accessPolicyIdentity(accessPolicyIdentity.buildAwsValue())
      .accessPolicyResource(accessPolicyResource.buildAwsValue())
      .accessPolicyPermission(accessPolicyPermission.unwrap)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.CreateAccessPolicyRequest.ReadOnly =
    zio.aws.iotsitewise.model.CreateAccessPolicyRequest.wrap(buildAwsValue())
}
object CreateAccessPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.CreateAccessPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.CreateAccessPolicyRequest =
      zio.aws.iotsitewise.model.CreateAccessPolicyRequest(
        accessPolicyIdentity.asEditable,
        accessPolicyResource.asEditable,
        accessPolicyPermission,
        clientToken.map(value => value),
        tags.map(value => value)
      )
    def accessPolicyIdentity: zio.aws.iotsitewise.model.Identity.ReadOnly
    def accessPolicyResource: zio.aws.iotsitewise.model.Resource.ReadOnly
    def accessPolicyPermission: zio.aws.iotsitewise.model.Permission
    def clientToken: Optional[ClientToken]
    def tags: Optional[Map[TagKey, TagValue]]
    def getAccessPolicyIdentity
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.Identity.ReadOnly] =
      ZIO.succeed(accessPolicyIdentity)
    def getAccessPolicyResource
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.Resource.ReadOnly] =
      ZIO.succeed(accessPolicyResource)
    def getAccessPolicyPermission
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.Permission] =
      ZIO.succeed(accessPolicyPermission)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateAccessPolicyRequest
  ) extends zio.aws.iotsitewise.model.CreateAccessPolicyRequest.ReadOnly {
    override val accessPolicyIdentity
        : zio.aws.iotsitewise.model.Identity.ReadOnly =
      zio.aws.iotsitewise.model.Identity.wrap(impl.accessPolicyIdentity())
    override val accessPolicyResource
        : zio.aws.iotsitewise.model.Resource.ReadOnly =
      zio.aws.iotsitewise.model.Resource.wrap(impl.accessPolicyResource())
    override val accessPolicyPermission: zio.aws.iotsitewise.model.Permission =
      zio.aws.iotsitewise.model.Permission.wrap(impl.accessPolicyPermission())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iotsitewise.model.primitives.TagKey(
              key
            ) -> zio.aws.iotsitewise.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateAccessPolicyRequest
  ): zio.aws.iotsitewise.model.CreateAccessPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
