package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.DefaultValue
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Attribute(
    defaultValue: Optional[DefaultValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.Attribute = {
    import Attribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.Attribute
      .builder()
      .optionallyWith(
        defaultValue.map(value => DefaultValue.unwrap(value): java.lang.String)
      )(_.defaultValue)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.Attribute.ReadOnly =
    zio.aws.iotsitewise.model.Attribute.wrap(buildAwsValue())
}
object Attribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.Attribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.Attribute =
      zio.aws.iotsitewise.model.Attribute(defaultValue.map(value => value))
    def defaultValue: Optional[DefaultValue]
    def getDefaultValue: ZIO[Any, AwsError, DefaultValue] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.Attribute
  ) extends zio.aws.iotsitewise.model.Attribute.ReadOnly {
    override val defaultValue: Optional[DefaultValue] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultValue())
      .map(value => zio.aws.iotsitewise.model.primitives.DefaultValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.Attribute
  ): zio.aws.iotsitewise.model.Attribute.ReadOnly = new Wrapper(impl)
}
