package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{PropertyUnit, Name, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssetModelPropertySummary(
    id: Optional[ID] = Optional.Absent,
    name: Name,
    dataType: zio.aws.iotsitewise.model.PropertyDataType,
    dataTypeSpec: Optional[Name] = Optional.Absent,
    unit: Optional[PropertyUnit] = Optional.Absent,
    `type`: zio.aws.iotsitewise.model.PropertyType,
    assetModelCompositeModelId: Optional[ID] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertySummary = {
    import AssetModelPropertySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertySummary
      .builder()
      .optionallyWith(id.map(value => ID.unwrap(value): java.lang.String))(_.id)
      .name(Name.unwrap(name): java.lang.String)
      .dataType(dataType.unwrap)
      .optionallyWith(
        dataTypeSpec.map(value => Name.unwrap(value): java.lang.String)
      )(_.dataTypeSpec)
      .optionallyWith(
        unit.map(value => PropertyUnit.unwrap(value): java.lang.String)
      )(_.unit)
      .`type`(`type`.buildAwsValue())
      .optionallyWith(
        assetModelCompositeModelId.map(value =>
          ID.unwrap(value): java.lang.String
        )
      )(_.assetModelCompositeModelId)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.AssetModelPropertySummary.ReadOnly =
    zio.aws.iotsitewise.model.AssetModelPropertySummary.wrap(buildAwsValue())
}
object AssetModelPropertySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.AssetModelPropertySummary =
      zio.aws.iotsitewise.model.AssetModelPropertySummary(
        id.map(value => value),
        name,
        dataType,
        dataTypeSpec.map(value => value),
        unit.map(value => value),
        `type`.asEditable,
        assetModelCompositeModelId.map(value => value)
      )
    def id: Optional[ID]
    def name: Name
    def dataType: zio.aws.iotsitewise.model.PropertyDataType
    def dataTypeSpec: Optional[Name]
    def unit: Optional[PropertyUnit]
    def `type`: zio.aws.iotsitewise.model.PropertyType.ReadOnly
    def assetModelCompositeModelId: Optional[ID]
    def getId: ZIO[Any, AwsError, ID] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDataType
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.PropertyDataType] =
      ZIO.succeed(dataType)
    def getDataTypeSpec: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("dataTypeSpec", dataTypeSpec)
    def getUnit: ZIO[Any, AwsError, PropertyUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getType
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.PropertyType.ReadOnly] =
      ZIO.succeed(`type`)
    def getAssetModelCompositeModelId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField(
        "assetModelCompositeModelId",
        assetModelCompositeModelId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertySummary
  ) extends zio.aws.iotsitewise.model.AssetModelPropertySummary.ReadOnly {
    override val id: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val name: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.name())
    override val dataType: zio.aws.iotsitewise.model.PropertyDataType =
      zio.aws.iotsitewise.model.PropertyDataType.wrap(impl.dataType())
    override val dataTypeSpec: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.dataTypeSpec())
      .map(value => zio.aws.iotsitewise.model.primitives.Name(value))
    override val unit: Optional[PropertyUnit] = zio.aws.core.internal
      .optionalFromNullable(impl.unit())
      .map(value => zio.aws.iotsitewise.model.primitives.PropertyUnit(value))
    override val `type`: zio.aws.iotsitewise.model.PropertyType.ReadOnly =
      zio.aws.iotsitewise.model.PropertyType.wrap(impl.`type`())
    override val assetModelCompositeModelId: Optional[ID] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assetModelCompositeModelId())
        .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertySummary
  ): zio.aws.iotsitewise.model.AssetModelPropertySummary.ReadOnly = new Wrapper(
    impl
  )
}
