package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ID, Name}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssetModelHierarchyDefinition(
    name: Name,
    childAssetModelId: ID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchyDefinition = {
    import AssetModelHierarchyDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchyDefinition
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .childAssetModelId(ID.unwrap(childAssetModelId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.AssetModelHierarchyDefinition.ReadOnly =
    zio.aws.iotsitewise.model.AssetModelHierarchyDefinition
      .wrap(buildAwsValue())
}
object AssetModelHierarchyDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchyDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.AssetModelHierarchyDefinition =
      zio.aws.iotsitewise.model
        .AssetModelHierarchyDefinition(name, childAssetModelId)
    def name: Name
    def childAssetModelId: ID
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getChildAssetModelId: ZIO[Any, Nothing, ID] =
      ZIO.succeed(childAssetModelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchyDefinition
  ) extends zio.aws.iotsitewise.model.AssetModelHierarchyDefinition.ReadOnly {
    override val name: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.name())
    override val childAssetModelId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.childAssetModelId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchyDefinition
  ): zio.aws.iotsitewise.model.AssetModelHierarchyDefinition.ReadOnly =
    new Wrapper(impl)
}
