package zio.aws.iotsitewise.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.Timestamp
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeStorageConfigurationResponse(
    storageType: zio.aws.iotsitewise.model.StorageType,
    multiLayerStorage: Optional[zio.aws.iotsitewise.model.MultiLayerStorage] =
      Optional.Absent,
    disassociatedDataStorage: Optional[
      zio.aws.iotsitewise.model.DisassociatedDataStorageState
    ] = Optional.Absent,
    retentionPeriod: Optional[zio.aws.iotsitewise.model.RetentionPeriod] =
      Optional.Absent,
    configurationStatus: zio.aws.iotsitewise.model.ConfigurationStatus,
    lastUpdateDate: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeStorageConfigurationResponse = {
    import DescribeStorageConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeStorageConfigurationResponse
      .builder()
      .storageType(storageType.unwrap)
      .optionallyWith(multiLayerStorage.map(value => value.buildAwsValue()))(
        _.multiLayerStorage
      )
      .optionallyWith(disassociatedDataStorage.map(value => value.unwrap))(
        _.disassociatedDataStorage
      )
      .optionallyWith(retentionPeriod.map(value => value.buildAwsValue()))(
        _.retentionPeriod
      )
      .configurationStatus(configurationStatus.buildAwsValue())
      .optionallyWith(
        lastUpdateDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateDate)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.DescribeStorageConfigurationResponse.ReadOnly =
    zio.aws.iotsitewise.model.DescribeStorageConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeStorageConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeStorageConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.DescribeStorageConfigurationResponse =
      zio.aws.iotsitewise.model.DescribeStorageConfigurationResponse(
        storageType,
        multiLayerStorage.map(value => value.asEditable),
        disassociatedDataStorage.map(value => value),
        retentionPeriod.map(value => value.asEditable),
        configurationStatus.asEditable,
        lastUpdateDate.map(value => value)
      )
    def storageType: zio.aws.iotsitewise.model.StorageType
    def multiLayerStorage
        : Optional[zio.aws.iotsitewise.model.MultiLayerStorage.ReadOnly]
    def disassociatedDataStorage
        : Optional[zio.aws.iotsitewise.model.DisassociatedDataStorageState]
    def retentionPeriod
        : Optional[zio.aws.iotsitewise.model.RetentionPeriod.ReadOnly]
    def configurationStatus
        : zio.aws.iotsitewise.model.ConfigurationStatus.ReadOnly
    def lastUpdateDate: Optional[Timestamp]
    def getStorageType
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.StorageType] =
      ZIO.succeed(storageType)
    def getMultiLayerStorage: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.MultiLayerStorage.ReadOnly
    ] = AwsError.unwrapOptionField("multiLayerStorage", multiLayerStorage)
    def getDisassociatedDataStorage: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.DisassociatedDataStorageState
    ] = AwsError.unwrapOptionField(
      "disassociatedDataStorage",
      disassociatedDataStorage
    )
    def getRetentionPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.RetentionPeriod.ReadOnly
    ] = AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
    def getConfigurationStatus: ZIO[
      Any,
      Nothing,
      zio.aws.iotsitewise.model.ConfigurationStatus.ReadOnly
    ] = ZIO.succeed(configurationStatus)
    def getLastUpdateDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateDate", lastUpdateDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeStorageConfigurationResponse
  ) extends zio.aws.iotsitewise.model.DescribeStorageConfigurationResponse.ReadOnly {
    override val storageType: zio.aws.iotsitewise.model.StorageType =
      zio.aws.iotsitewise.model.StorageType.wrap(impl.storageType())
    override val multiLayerStorage
        : Optional[zio.aws.iotsitewise.model.MultiLayerStorage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.multiLayerStorage())
        .map(value => zio.aws.iotsitewise.model.MultiLayerStorage.wrap(value))
    override val disassociatedDataStorage
        : Optional[zio.aws.iotsitewise.model.DisassociatedDataStorageState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disassociatedDataStorage())
        .map(value =>
          zio.aws.iotsitewise.model.DisassociatedDataStorageState.wrap(value)
        )
    override val retentionPeriod
        : Optional[zio.aws.iotsitewise.model.RetentionPeriod.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionPeriod())
        .map(value => zio.aws.iotsitewise.model.RetentionPeriod.wrap(value))
    override val configurationStatus
        : zio.aws.iotsitewise.model.ConfigurationStatus.ReadOnly =
      zio.aws.iotsitewise.model.ConfigurationStatus
        .wrap(impl.configurationStatus())
    override val lastUpdateDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdateDate())
      .map(value => zio.aws.iotsitewise.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeStorageConfigurationResponse
  ): zio.aws.iotsitewise.model.DescribeStorageConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
