package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ClientToken, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeletePortalRequest(
    portalId: ID,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DeletePortalRequest = {
    import DeletePortalRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DeletePortalRequest
      .builder()
      .portalId(ID.unwrap(portalId): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DeletePortalRequest.ReadOnly =
    zio.aws.iotsitewise.model.DeletePortalRequest.wrap(buildAwsValue())
}
object DeletePortalRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DeletePortalRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DeletePortalRequest =
      zio.aws.iotsitewise.model
        .DeletePortalRequest(portalId, clientToken.map(value => value))
    def portalId: ID
    def clientToken: Optional[ClientToken]
    def getPortalId: ZIO[Any, Nothing, ID] = ZIO.succeed(portalId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DeletePortalRequest
  ) extends zio.aws.iotsitewise.model.DeletePortalRequest.ReadOnly {
    override val portalId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.portalId())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DeletePortalRequest
  ): zio.aws.iotsitewise.model.DeletePortalRequest.ReadOnly = new Wrapper(impl)
}
