package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ClientToken, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteDashboardRequest(
    dashboardId: ID,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DeleteDashboardRequest = {
    import DeleteDashboardRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DeleteDashboardRequest
      .builder()
      .dashboardId(ID.unwrap(dashboardId): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DeleteDashboardRequest.ReadOnly =
    zio.aws.iotsitewise.model.DeleteDashboardRequest.wrap(buildAwsValue())
}
object DeleteDashboardRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DeleteDashboardRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DeleteDashboardRequest =
      zio.aws.iotsitewise.model
        .DeleteDashboardRequest(dashboardId, clientToken.map(value => value))
    def dashboardId: ID
    def clientToken: Optional[ClientToken]
    def getDashboardId: ZIO[Any, Nothing, ID] = ZIO.succeed(dashboardId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DeleteDashboardRequest
  ) extends zio.aws.iotsitewise.model.DeleteDashboardRequest.ReadOnly {
    override val dashboardId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.dashboardId())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DeleteDashboardRequest
  ): zio.aws.iotsitewise.model.DeleteDashboardRequest.ReadOnly = new Wrapper(
    impl
  )
}
