package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssetRelationshipSummary(
    hierarchyInfo: Optional[zio.aws.iotsitewise.model.AssetHierarchyInfo] =
      Optional.Absent,
    relationshipType: zio.aws.iotsitewise.model.AssetRelationshipType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.AssetRelationshipSummary = {
    import AssetRelationshipSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.AssetRelationshipSummary
      .builder()
      .optionallyWith(hierarchyInfo.map(value => value.buildAwsValue()))(
        _.hierarchyInfo
      )
      .relationshipType(relationshipType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.AssetRelationshipSummary.ReadOnly =
    zio.aws.iotsitewise.model.AssetRelationshipSummary.wrap(buildAwsValue())
}
object AssetRelationshipSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.AssetRelationshipSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.AssetRelationshipSummary =
      zio.aws.iotsitewise.model.AssetRelationshipSummary(
        hierarchyInfo.map(value => value.asEditable),
        relationshipType
      )
    def hierarchyInfo
        : Optional[zio.aws.iotsitewise.model.AssetHierarchyInfo.ReadOnly]
    def relationshipType: zio.aws.iotsitewise.model.AssetRelationshipType
    def getHierarchyInfo: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.AssetHierarchyInfo.ReadOnly
    ] = AwsError.unwrapOptionField("hierarchyInfo", hierarchyInfo)
    def getRelationshipType
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.AssetRelationshipType] =
      ZIO.succeed(relationshipType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetRelationshipSummary
  ) extends zio.aws.iotsitewise.model.AssetRelationshipSummary.ReadOnly {
    override val hierarchyInfo
        : Optional[zio.aws.iotsitewise.model.AssetHierarchyInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hierarchyInfo())
        .map(value => zio.aws.iotsitewise.model.AssetHierarchyInfo.wrap(value))
    override val relationshipType
        : zio.aws.iotsitewise.model.AssetRelationshipType =
      zio.aws.iotsitewise.model.AssetRelationshipType
        .wrap(impl.relationshipType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetRelationshipSummary
  ): zio.aws.iotsitewise.model.AssetRelationshipSummary.ReadOnly = new Wrapper(
    impl
  )
}
