package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssetModelStatus(
    state: zio.aws.iotsitewise.model.AssetModelState,
    error: Optional[zio.aws.iotsitewise.model.ErrorDetails] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.AssetModelStatus = {
    import AssetModelStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.AssetModelStatus
      .builder()
      .state(state.unwrap)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.AssetModelStatus.ReadOnly =
    zio.aws.iotsitewise.model.AssetModelStatus.wrap(buildAwsValue())
}
object AssetModelStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.AssetModelStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.AssetModelStatus =
      zio.aws.iotsitewise.model
        .AssetModelStatus(state, error.map(value => value.asEditable))
    def state: zio.aws.iotsitewise.model.AssetModelState
    def error: Optional[zio.aws.iotsitewise.model.ErrorDetails.ReadOnly]
    def getState: ZIO[Any, Nothing, zio.aws.iotsitewise.model.AssetModelState] =
      ZIO.succeed(state)
    def getError
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.ErrorDetails.ReadOnly] =
      AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetModelStatus
  ) extends zio.aws.iotsitewise.model.AssetModelStatus.ReadOnly {
    override val state: zio.aws.iotsitewise.model.AssetModelState =
      zio.aws.iotsitewise.model.AssetModelState.wrap(impl.state())
    override val error
        : Optional[zio.aws.iotsitewise.model.ErrorDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.error())
        .map(value => zio.aws.iotsitewise.model.ErrorDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetModelStatus
  ): zio.aws.iotsitewise.model.AssetModelStatus.ReadOnly = new Wrapper(impl)
}
