package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ID
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssetHierarchyInfo(
    parentAssetId: Optional[ID] = Optional.Absent,
    childAssetId: Optional[ID] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.AssetHierarchyInfo = {
    import AssetHierarchyInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.AssetHierarchyInfo
      .builder()
      .optionallyWith(
        parentAssetId.map(value => ID.unwrap(value): java.lang.String)
      )(_.parentAssetId)
      .optionallyWith(
        childAssetId.map(value => ID.unwrap(value): java.lang.String)
      )(_.childAssetId)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.AssetHierarchyInfo.ReadOnly =
    zio.aws.iotsitewise.model.AssetHierarchyInfo.wrap(buildAwsValue())
}
object AssetHierarchyInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.AssetHierarchyInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.AssetHierarchyInfo =
      zio.aws.iotsitewise.model.AssetHierarchyInfo(
        parentAssetId.map(value => value),
        childAssetId.map(value => value)
      )
    def parentAssetId: Optional[ID]
    def childAssetId: Optional[ID]
    def getParentAssetId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("parentAssetId", parentAssetId)
    def getChildAssetId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("childAssetId", childAssetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetHierarchyInfo
  ) extends zio.aws.iotsitewise.model.AssetHierarchyInfo.ReadOnly {
    override val parentAssetId: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.parentAssetId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val childAssetId: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.childAssetId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetHierarchyInfo
  ): zio.aws.iotsitewise.model.AssetHierarchyInfo.ReadOnly = new Wrapper(impl)
}
