package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{
  PropertyUnit,
  ClientToken,
  PropertyAlias,
  ID
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAssetPropertyRequest(
    assetId: ID,
    propertyId: ID,
    propertyAlias: Optional[PropertyAlias] = Optional.Absent,
    propertyNotificationState: Optional[
      zio.aws.iotsitewise.model.PropertyNotificationState
    ] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    propertyUnit: Optional[PropertyUnit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.UpdateAssetPropertyRequest = {
    import UpdateAssetPropertyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.UpdateAssetPropertyRequest
      .builder()
      .assetId(ID.unwrap(assetId): java.lang.String)
      .propertyId(ID.unwrap(propertyId): java.lang.String)
      .optionallyWith(
        propertyAlias.map(value =>
          PropertyAlias.unwrap(value): java.lang.String
        )
      )(_.propertyAlias)
      .optionallyWith(propertyNotificationState.map(value => value.unwrap))(
        _.propertyNotificationState
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        propertyUnit.map(value => PropertyUnit.unwrap(value): java.lang.String)
      )(_.propertyUnit)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.UpdateAssetPropertyRequest.ReadOnly =
    zio.aws.iotsitewise.model.UpdateAssetPropertyRequest.wrap(buildAwsValue())
}
object UpdateAssetPropertyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.UpdateAssetPropertyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.UpdateAssetPropertyRequest =
      zio.aws.iotsitewise.model.UpdateAssetPropertyRequest(
        assetId,
        propertyId,
        propertyAlias.map(value => value),
        propertyNotificationState.map(value => value),
        clientToken.map(value => value),
        propertyUnit.map(value => value)
      )
    def assetId: ID
    def propertyId: ID
    def propertyAlias: Optional[PropertyAlias]
    def propertyNotificationState
        : Optional[zio.aws.iotsitewise.model.PropertyNotificationState]
    def clientToken: Optional[ClientToken]
    def propertyUnit: Optional[PropertyUnit]
    def getAssetId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetId)
    def getPropertyId: ZIO[Any, Nothing, ID] = ZIO.succeed(propertyId)
    def getPropertyAlias: ZIO[Any, AwsError, PropertyAlias] =
      AwsError.unwrapOptionField("propertyAlias", propertyAlias)
    def getPropertyNotificationState: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.PropertyNotificationState
    ] = AwsError.unwrapOptionField(
      "propertyNotificationState",
      propertyNotificationState
    )
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getPropertyUnit: ZIO[Any, AwsError, PropertyUnit] =
      AwsError.unwrapOptionField("propertyUnit", propertyUnit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdateAssetPropertyRequest
  ) extends zio.aws.iotsitewise.model.UpdateAssetPropertyRequest.ReadOnly {
    override val assetId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetId())
    override val propertyId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.propertyId())
    override val propertyAlias: Optional[PropertyAlias] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyAlias())
      .map(value => zio.aws.iotsitewise.model.primitives.PropertyAlias(value))
    override val propertyNotificationState
        : Optional[zio.aws.iotsitewise.model.PropertyNotificationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propertyNotificationState())
        .map(value =>
          zio.aws.iotsitewise.model.PropertyNotificationState.wrap(value)
        )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
    override val propertyUnit: Optional[PropertyUnit] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyUnit())
      .map(value => zio.aws.iotsitewise.model.primitives.PropertyUnit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdateAssetPropertyRequest
  ): zio.aws.iotsitewise.model.UpdateAssetPropertyRequest.ReadOnly =
    new Wrapper(impl)
}
