package zio.aws.iotsitewise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{MaxResults, NextToken, ID}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAssetPropertiesRequest(
    assetId: ID,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    filter: Optional[zio.aws.iotsitewise.model.ListAssetPropertiesFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesRequest = {
    import ListAssetPropertiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesRequest
      .builder()
      .assetId(ID.unwrap(assetId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(filter.map(value => value.unwrap))(_.filter)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.ListAssetPropertiesRequest.ReadOnly =
    zio.aws.iotsitewise.model.ListAssetPropertiesRequest.wrap(buildAwsValue())
}
object ListAssetPropertiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListAssetPropertiesRequest =
      zio.aws.iotsitewise.model.ListAssetPropertiesRequest(
        assetId,
        nextToken.map(value => value),
        maxResults.map(value => value),
        filter.map(value => value)
      )
    def assetId: ID
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def filter: Optional[zio.aws.iotsitewise.model.ListAssetPropertiesFilter]
    def getAssetId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.ListAssetPropertiesFilter
    ] = AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesRequest
  ) extends zio.aws.iotsitewise.model.ListAssetPropertiesRequest.ReadOnly {
    override val assetId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotsitewise.model.primitives.MaxResults(value))
    override val filter
        : Optional[zio.aws.iotsitewise.model.ListAssetPropertiesFilter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value =>
          zio.aws.iotsitewise.model.ListAssetPropertiesFilter.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssetPropertiesRequest
  ): zio.aws.iotsitewise.model.ListAssetPropertiesRequest.ReadOnly =
    new Wrapper(impl)
}
