package zio.aws.iotsitewise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{MaxResults, NextToken, ID}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAssetModelPropertiesRequest(
    assetModelId: ID,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    filter: Optional[zio.aws.iotsitewise.model.ListAssetModelPropertiesFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesRequest = {
    import ListAssetModelPropertiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesRequest
      .builder()
      .assetModelId(ID.unwrap(assetModelId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(filter.map(value => value.unwrap))(_.filter)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.ListAssetModelPropertiesRequest.ReadOnly =
    zio.aws.iotsitewise.model.ListAssetModelPropertiesRequest
      .wrap(buildAwsValue())
}
object ListAssetModelPropertiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListAssetModelPropertiesRequest =
      zio.aws.iotsitewise.model.ListAssetModelPropertiesRequest(
        assetModelId,
        nextToken.map(value => value),
        maxResults.map(value => value),
        filter.map(value => value)
      )
    def assetModelId: ID
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def filter
        : Optional[zio.aws.iotsitewise.model.ListAssetModelPropertiesFilter]
    def getAssetModelId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetModelId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.ListAssetModelPropertiesFilter
    ] = AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesRequest
  ) extends zio.aws.iotsitewise.model.ListAssetModelPropertiesRequest.ReadOnly {
    override val assetModelId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetModelId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotsitewise.model.primitives.MaxResults(value))
    override val filter
        : Optional[zio.aws.iotsitewise.model.ListAssetModelPropertiesFilter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value =>
          zio.aws.iotsitewise.model.ListAssetModelPropertiesFilter.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssetModelPropertiesRequest
  ): zio.aws.iotsitewise.model.ListAssetModelPropertiesRequest.ReadOnly =
    new Wrapper(impl)
}
