package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class JobConfiguration(
    fileFormat: zio.aws.iotsitewise.model.FileFormat
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.JobConfiguration = {
    import JobConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.JobConfiguration
      .builder()
      .fileFormat(fileFormat.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.JobConfiguration.ReadOnly =
    zio.aws.iotsitewise.model.JobConfiguration.wrap(buildAwsValue())
}
object JobConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.JobConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.JobConfiguration =
      zio.aws.iotsitewise.model.JobConfiguration(fileFormat.asEditable)
    def fileFormat: zio.aws.iotsitewise.model.FileFormat.ReadOnly
    def getFileFormat
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.FileFormat.ReadOnly] =
      ZIO.succeed(fileFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.JobConfiguration
  ) extends zio.aws.iotsitewise.model.JobConfiguration.ReadOnly {
    override val fileFormat: zio.aws.iotsitewise.model.FileFormat.ReadOnly =
      zio.aws.iotsitewise.model.FileFormat.wrap(impl.fileFormat())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.JobConfiguration
  ): zio.aws.iotsitewise.model.JobConfiguration.ReadOnly = new Wrapper(impl)
}
