package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters._
sealed trait ErrorCode {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.ErrorCode
}
object ErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.ErrorCode
  ): zio.aws.iotsitewise.model.ErrorCode = value match {
    case software.amazon.awssdk.services.iotsitewise.model.ErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.ErrorCode.VALIDATION_ERROR =>
      val r = VALIDATION_ERROR
      r
    case software.amazon.awssdk.services.iotsitewise.model.ErrorCode.INTERNAL_FAILURE =>
      val r = INTERNAL_FAILURE
      r
  }
  case object unknownToSdkVersion extends zio.aws.iotsitewise.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.ErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.ErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object VALIDATION_ERROR extends zio.aws.iotsitewise.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.ErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.ErrorCode.VALIDATION_ERROR
  }
  case object INTERNAL_FAILURE extends zio.aws.iotsitewise.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.ErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.ErrorCode.INTERNAL_FAILURE
  }
}
