package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ARN
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDefaultEncryptionConfigurationResponse(
    encryptionType: zio.aws.iotsitewise.model.EncryptionType,
    kmsKeyArn: Optional[ARN] = Optional.Absent,
    configurationStatus: zio.aws.iotsitewise.model.ConfigurationStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeDefaultEncryptionConfigurationResponse = {
    import DescribeDefaultEncryptionConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeDefaultEncryptionConfigurationResponse
      .builder()
      .encryptionType(encryptionType.unwrap)
      .optionallyWith(
        kmsKeyArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .configurationStatus(configurationStatus.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.DescribeDefaultEncryptionConfigurationResponse.ReadOnly =
    zio.aws.iotsitewise.model.DescribeDefaultEncryptionConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeDefaultEncryptionConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeDefaultEncryptionConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.DescribeDefaultEncryptionConfigurationResponse =
      zio.aws.iotsitewise.model.DescribeDefaultEncryptionConfigurationResponse(
        encryptionType,
        kmsKeyArn.map(value => value),
        configurationStatus.asEditable
      )
    def encryptionType: zio.aws.iotsitewise.model.EncryptionType
    def kmsKeyArn: Optional[ARN]
    def configurationStatus
        : zio.aws.iotsitewise.model.ConfigurationStatus.ReadOnly
    def getEncryptionType
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.EncryptionType] =
      ZIO.succeed(encryptionType)
    def getKmsKeyArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getConfigurationStatus: ZIO[
      Any,
      Nothing,
      zio.aws.iotsitewise.model.ConfigurationStatus.ReadOnly
    ] = ZIO.succeed(configurationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeDefaultEncryptionConfigurationResponse
  ) extends zio.aws.iotsitewise.model.DescribeDefaultEncryptionConfigurationResponse.ReadOnly {
    override val encryptionType: zio.aws.iotsitewise.model.EncryptionType =
      zio.aws.iotsitewise.model.EncryptionType.wrap(impl.encryptionType())
    override val kmsKeyArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.iotsitewise.model.primitives.ARN(value))
    override val configurationStatus
        : zio.aws.iotsitewise.model.ConfigurationStatus.ReadOnly =
      zio.aws.iotsitewise.model.ConfigurationStatus
        .wrap(impl.configurationStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeDefaultEncryptionConfigurationResponse
  ): zio.aws.iotsitewise.model.DescribeDefaultEncryptionConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
