package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ID, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CompositeModelProperty(
    name: Name,
    `type`: Name,
    assetProperty: zio.aws.iotsitewise.model.Property,
    id: Optional[ID] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.CompositeModelProperty = {
    import CompositeModelProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.CompositeModelProperty
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .`type`(Name.unwrap(`type`): java.lang.String)
      .assetProperty(assetProperty.buildAwsValue())
      .optionallyWith(id.map(value => ID.unwrap(value): java.lang.String))(_.id)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.CompositeModelProperty.ReadOnly =
    zio.aws.iotsitewise.model.CompositeModelProperty.wrap(buildAwsValue())
}
object CompositeModelProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.CompositeModelProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.CompositeModelProperty =
      zio.aws.iotsitewise.model.CompositeModelProperty(
        name,
        `type`,
        assetProperty.asEditable,
        id.map(value => value)
      )
    def name: Name
    def `type`: Name
    def assetProperty: zio.aws.iotsitewise.model.Property.ReadOnly
    def id: Optional[ID]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, Name] = ZIO.succeed(`type`)
    def getAssetProperty
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.Property.ReadOnly] =
      ZIO.succeed(assetProperty)
    def getId: ZIO[Any, AwsError, ID] = AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.CompositeModelProperty
  ) extends zio.aws.iotsitewise.model.CompositeModelProperty.ReadOnly {
    override val name: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.name())
    override val `type`: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.`type`())
    override val assetProperty: zio.aws.iotsitewise.model.Property.ReadOnly =
      zio.aws.iotsitewise.model.Property.wrap(impl.assetProperty())
    override val id: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.CompositeModelProperty
  ): zio.aws.iotsitewise.model.CompositeModelProperty.ReadOnly = new Wrapper(
    impl
  )
}
