package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PropertyType(
    attribute: Optional[zio.aws.iotsitewise.model.Attribute] = Optional.Absent,
    measurement: Optional[zio.aws.iotsitewise.model.Measurement] =
      Optional.Absent,
    transform: Optional[zio.aws.iotsitewise.model.Transform] = Optional.Absent,
    metric: Optional[zio.aws.iotsitewise.model.Metric] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.PropertyType = {
    import PropertyType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.PropertyType
      .builder()
      .optionallyWith(attribute.map(value => value.buildAwsValue()))(
        _.attribute
      )
      .optionallyWith(measurement.map(value => value.buildAwsValue()))(
        _.measurement
      )
      .optionallyWith(transform.map(value => value.buildAwsValue()))(
        _.transform
      )
      .optionallyWith(metric.map(value => value.buildAwsValue()))(_.metric)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.PropertyType.ReadOnly =
    zio.aws.iotsitewise.model.PropertyType.wrap(buildAwsValue())
}
object PropertyType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.PropertyType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.PropertyType =
      zio.aws.iotsitewise.model.PropertyType(
        attribute.map(value => value.asEditable),
        measurement.map(value => value.asEditable),
        transform.map(value => value.asEditable),
        metric.map(value => value.asEditable)
      )
    def attribute: Optional[zio.aws.iotsitewise.model.Attribute.ReadOnly]
    def measurement: Optional[zio.aws.iotsitewise.model.Measurement.ReadOnly]
    def transform: Optional[zio.aws.iotsitewise.model.Transform.ReadOnly]
    def metric: Optional[zio.aws.iotsitewise.model.Metric.ReadOnly]
    def getAttribute
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.Attribute.ReadOnly] =
      AwsError.unwrapOptionField("attribute", attribute)
    def getMeasurement
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.Measurement.ReadOnly] =
      AwsError.unwrapOptionField("measurement", measurement)
    def getTransform
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.Transform.ReadOnly] =
      AwsError.unwrapOptionField("transform", transform)
    def getMetric
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.Metric.ReadOnly] =
      AwsError.unwrapOptionField("metric", metric)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.PropertyType
  ) extends zio.aws.iotsitewise.model.PropertyType.ReadOnly {
    override val attribute
        : Optional[zio.aws.iotsitewise.model.Attribute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attribute())
        .map(value => zio.aws.iotsitewise.model.Attribute.wrap(value))
    override val measurement
        : Optional[zio.aws.iotsitewise.model.Measurement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.measurement())
        .map(value => zio.aws.iotsitewise.model.Measurement.wrap(value))
    override val transform
        : Optional[zio.aws.iotsitewise.model.Transform.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transform())
        .map(value => zio.aws.iotsitewise.model.Transform.wrap(value))
    override val metric: Optional[zio.aws.iotsitewise.model.Metric.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metric())
        .map(value => zio.aws.iotsitewise.model.Metric.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.PropertyType
  ): zio.aws.iotsitewise.model.PropertyType.ReadOnly = new Wrapper(impl)
}
