package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{Name, ID}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class JobSummary(
    id: ID,
    name: Name,
    status: zio.aws.iotsitewise.model.JobStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.JobSummary = {
    import JobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.JobSummary
      .builder()
      .id(ID.unwrap(id): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.JobSummary.ReadOnly =
    zio.aws.iotsitewise.model.JobSummary.wrap(buildAwsValue())
}
object JobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.JobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.JobSummary =
      zio.aws.iotsitewise.model.JobSummary(id, name, status)
    def id: ID
    def name: Name
    def status: zio.aws.iotsitewise.model.JobStatus
    def getId: ZIO[Any, Nothing, ID] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getStatus: ZIO[Any, Nothing, zio.aws.iotsitewise.model.JobStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.JobSummary
  ) extends zio.aws.iotsitewise.model.JobSummary.ReadOnly {
    override val id: ID = zio.aws.iotsitewise.model.primitives.ID(impl.id())
    override val name: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.name())
    override val status: zio.aws.iotsitewise.model.JobStatus =
      zio.aws.iotsitewise.model.JobStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.JobSummary
  ): zio.aws.iotsitewise.model.JobSummary.ReadOnly = new Wrapper(impl)
}
