package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.IdentityId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GroupIdentity(id: IdentityId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.GroupIdentity = {
    import GroupIdentity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.GroupIdentity
      .builder()
      .id(IdentityId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.GroupIdentity.ReadOnly =
    zio.aws.iotsitewise.model.GroupIdentity.wrap(buildAwsValue())
}
object GroupIdentity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.GroupIdentity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.GroupIdentity =
      zio.aws.iotsitewise.model.GroupIdentity(id)
    def id: IdentityId
    def getId: ZIO[Any, Nothing, IdentityId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.GroupIdentity
  ) extends zio.aws.iotsitewise.model.GroupIdentity.ReadOnly {
    override val id: IdentityId =
      zio.aws.iotsitewise.model.primitives.IdentityId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.GroupIdentity
  ): zio.aws.iotsitewise.model.GroupIdentity.ReadOnly = new Wrapper(impl)
}
