package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ID
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribePortalRequest(portalId: ID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribePortalRequest = {
    import DescribePortalRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribePortalRequest
      .builder()
      .portalId(ID.unwrap(portalId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DescribePortalRequest.ReadOnly =
    zio.aws.iotsitewise.model.DescribePortalRequest.wrap(buildAwsValue())
}
object DescribePortalRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribePortalRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DescribePortalRequest =
      zio.aws.iotsitewise.model.DescribePortalRequest(portalId)
    def portalId: ID
    def getPortalId: ZIO[Any, Nothing, ID] = ZIO.succeed(portalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribePortalRequest
  ) extends zio.aws.iotsitewise.model.DescribePortalRequest.ReadOnly {
    override val portalId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.portalId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribePortalRequest
  ): zio.aws.iotsitewise.model.DescribePortalRequest.ReadOnly = new Wrapper(
    impl
  )
}
