package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{Timestamp, ARN, Name, ID}
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeBulkImportJobResponse(
    jobId: ID,
    jobName: Name,
    jobStatus: zio.aws.iotsitewise.model.JobStatus,
    jobRoleArn: ARN,
    files: Iterable[zio.aws.iotsitewise.model.File],
    errorReportLocation: zio.aws.iotsitewise.model.ErrorReportLocation,
    jobConfiguration: zio.aws.iotsitewise.model.JobConfiguration,
    jobCreationDate: Timestamp,
    jobLastUpdateDate: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeBulkImportJobResponse = {
    import DescribeBulkImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeBulkImportJobResponse
      .builder()
      .jobId(ID.unwrap(jobId): java.lang.String)
      .jobName(Name.unwrap(jobName): java.lang.String)
      .jobStatus(jobStatus.unwrap)
      .jobRoleArn(ARN.unwrap(jobRoleArn): java.lang.String)
      .files(files.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .errorReportLocation(errorReportLocation.buildAwsValue())
      .jobConfiguration(jobConfiguration.buildAwsValue())
      .jobCreationDate(Timestamp.unwrap(jobCreationDate): Instant)
      .jobLastUpdateDate(Timestamp.unwrap(jobLastUpdateDate): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.DescribeBulkImportJobResponse.ReadOnly =
    zio.aws.iotsitewise.model.DescribeBulkImportJobResponse
      .wrap(buildAwsValue())
}
object DescribeBulkImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeBulkImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DescribeBulkImportJobResponse =
      zio.aws.iotsitewise.model.DescribeBulkImportJobResponse(
        jobId,
        jobName,
        jobStatus,
        jobRoleArn,
        files.map { item =>
          item.asEditable
        },
        errorReportLocation.asEditable,
        jobConfiguration.asEditable,
        jobCreationDate,
        jobLastUpdateDate
      )
    def jobId: ID
    def jobName: Name
    def jobStatus: zio.aws.iotsitewise.model.JobStatus
    def jobRoleArn: ARN
    def files: List[zio.aws.iotsitewise.model.File.ReadOnly]
    def errorReportLocation
        : zio.aws.iotsitewise.model.ErrorReportLocation.ReadOnly
    def jobConfiguration: zio.aws.iotsitewise.model.JobConfiguration.ReadOnly
    def jobCreationDate: Timestamp
    def jobLastUpdateDate: Timestamp
    def getJobId: ZIO[Any, Nothing, ID] = ZIO.succeed(jobId)
    def getJobName: ZIO[Any, Nothing, Name] = ZIO.succeed(jobName)
    def getJobStatus: ZIO[Any, Nothing, zio.aws.iotsitewise.model.JobStatus] =
      ZIO.succeed(jobStatus)
    def getJobRoleArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(jobRoleArn)
    def getFiles
        : ZIO[Any, Nothing, List[zio.aws.iotsitewise.model.File.ReadOnly]] =
      ZIO.succeed(files)
    def getErrorReportLocation: ZIO[
      Any,
      Nothing,
      zio.aws.iotsitewise.model.ErrorReportLocation.ReadOnly
    ] = ZIO.succeed(errorReportLocation)
    def getJobConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.iotsitewise.model.JobConfiguration.ReadOnly
    ] = ZIO.succeed(jobConfiguration)
    def getJobCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(jobCreationDate)
    def getJobLastUpdateDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(jobLastUpdateDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeBulkImportJobResponse
  ) extends zio.aws.iotsitewise.model.DescribeBulkImportJobResponse.ReadOnly {
    override val jobId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.jobId())
    override val jobName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.jobName())
    override val jobStatus: zio.aws.iotsitewise.model.JobStatus =
      zio.aws.iotsitewise.model.JobStatus.wrap(impl.jobStatus())
    override val jobRoleArn: ARN =
      zio.aws.iotsitewise.model.primitives.ARN(impl.jobRoleArn())
    override val files: List[zio.aws.iotsitewise.model.File.ReadOnly] = impl
      .files()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.File.wrap(item)
      }
      .toList
    override val errorReportLocation
        : zio.aws.iotsitewise.model.ErrorReportLocation.ReadOnly =
      zio.aws.iotsitewise.model.ErrorReportLocation
        .wrap(impl.errorReportLocation())
    override val jobConfiguration
        : zio.aws.iotsitewise.model.JobConfiguration.ReadOnly =
      zio.aws.iotsitewise.model.JobConfiguration.wrap(impl.jobConfiguration())
    override val jobCreationDate: Timestamp =
      zio.aws.iotsitewise.model.primitives.Timestamp(impl.jobCreationDate())
    override val jobLastUpdateDate: Timestamp =
      zio.aws.iotsitewise.model.primitives.Timestamp(impl.jobLastUpdateDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeBulkImportJobResponse
  ): zio.aws.iotsitewise.model.DescribeBulkImportJobResponse.ReadOnly =
    new Wrapper(impl)
}
