package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{
  TagValue,
  Email,
  Description,
  ClientToken,
  Name,
  ARN,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreatePortalRequest(
    portalName: Name,
    portalDescription: Optional[Description] = Optional.Absent,
    portalContactEmail: Email,
    clientToken: Optional[ClientToken] = Optional.Absent,
    portalLogoImageFile: Optional[zio.aws.iotsitewise.model.ImageFile] =
      Optional.Absent,
    roleArn: ARN,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    portalAuthMode: Optional[zio.aws.iotsitewise.model.AuthMode] =
      Optional.Absent,
    notificationSenderEmail: Optional[Email] = Optional.Absent,
    alarms: Optional[zio.aws.iotsitewise.model.Alarms] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.CreatePortalRequest = {
    import CreatePortalRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.CreatePortalRequest
      .builder()
      .portalName(Name.unwrap(portalName): java.lang.String)
      .optionallyWith(
        portalDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.portalDescription)
      .portalContactEmail(Email.unwrap(portalContactEmail): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(portalLogoImageFile.map(value => value.buildAwsValue()))(
        _.portalLogoImageFile
      )
      .roleArn(ARN.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(portalAuthMode.map(value => value.unwrap))(
        _.portalAuthMode
      )
      .optionallyWith(
        notificationSenderEmail.map(value =>
          Email.unwrap(value): java.lang.String
        )
      )(_.notificationSenderEmail)
      .optionallyWith(alarms.map(value => value.buildAwsValue()))(_.alarms)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.CreatePortalRequest.ReadOnly =
    zio.aws.iotsitewise.model.CreatePortalRequest.wrap(buildAwsValue())
}
object CreatePortalRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.CreatePortalRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.CreatePortalRequest =
      zio.aws.iotsitewise.model.CreatePortalRequest(
        portalName,
        portalDescription.map(value => value),
        portalContactEmail,
        clientToken.map(value => value),
        portalLogoImageFile.map(value => value.asEditable),
        roleArn,
        tags.map(value => value),
        portalAuthMode.map(value => value),
        notificationSenderEmail.map(value => value),
        alarms.map(value => value.asEditable)
      )
    def portalName: Name
    def portalDescription: Optional[Description]
    def portalContactEmail: Email
    def clientToken: Optional[ClientToken]
    def portalLogoImageFile
        : Optional[zio.aws.iotsitewise.model.ImageFile.ReadOnly]
    def roleArn: ARN
    def tags: Optional[Map[TagKey, TagValue]]
    def portalAuthMode: Optional[zio.aws.iotsitewise.model.AuthMode]
    def notificationSenderEmail: Optional[Email]
    def alarms: Optional[zio.aws.iotsitewise.model.Alarms.ReadOnly]
    def getPortalName: ZIO[Any, Nothing, Name] = ZIO.succeed(portalName)
    def getPortalDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("portalDescription", portalDescription)
    def getPortalContactEmail: ZIO[Any, Nothing, Email] =
      ZIO.succeed(portalContactEmail)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getPortalLogoImageFile
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.ImageFile.ReadOnly] =
      AwsError.unwrapOptionField("portalLogoImageFile", portalLogoImageFile)
    def getRoleArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(roleArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPortalAuthMode
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.AuthMode] =
      AwsError.unwrapOptionField("portalAuthMode", portalAuthMode)
    def getNotificationSenderEmail: ZIO[Any, AwsError, Email] = AwsError
      .unwrapOptionField("notificationSenderEmail", notificationSenderEmail)
    def getAlarms
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.Alarms.ReadOnly] =
      AwsError.unwrapOptionField("alarms", alarms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreatePortalRequest
  ) extends zio.aws.iotsitewise.model.CreatePortalRequest.ReadOnly {
    override val portalName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.portalName())
    override val portalDescription: Optional[Description] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portalDescription())
        .map(value => zio.aws.iotsitewise.model.primitives.Description(value))
    override val portalContactEmail: Email =
      zio.aws.iotsitewise.model.primitives.Email(impl.portalContactEmail())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
    override val portalLogoImageFile
        : Optional[zio.aws.iotsitewise.model.ImageFile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portalLogoImageFile())
        .map(value => zio.aws.iotsitewise.model.ImageFile.wrap(value))
    override val roleArn: ARN =
      zio.aws.iotsitewise.model.primitives.ARN(impl.roleArn())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iotsitewise.model.primitives.TagKey(
              key
            ) -> zio.aws.iotsitewise.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val portalAuthMode: Optional[zio.aws.iotsitewise.model.AuthMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portalAuthMode())
        .map(value => zio.aws.iotsitewise.model.AuthMode.wrap(value))
    override val notificationSenderEmail: Optional[Email] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationSenderEmail())
        .map(value => zio.aws.iotsitewise.model.primitives.Email(value))
    override val alarms: Optional[zio.aws.iotsitewise.model.Alarms.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarms())
        .map(value => zio.aws.iotsitewise.model.Alarms.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreatePortalRequest
  ): zio.aws.iotsitewise.model.CreatePortalRequest.ReadOnly = new Wrapper(impl)
}
