package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters._
sealed trait AssetErrorCode {
  def unwrap: software.amazon.awssdk.services.iotsitewise.model.AssetErrorCode
}
object AssetErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.AssetErrorCode
  ): zio.aws.iotsitewise.model.AssetErrorCode = value match {
    case software.amazon.awssdk.services.iotsitewise.model.AssetErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.AssetErrorCode.INTERNAL_FAILURE =>
      val r = INTERNAL_FAILURE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsitewise.model.AssetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AssetErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.AssetErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object INTERNAL_FAILURE
      extends zio.aws.iotsitewise.model.AssetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.AssetErrorCode =
      software.amazon.awssdk.services.iotsitewise.model.AssetErrorCode.INTERNAL_FAILURE
  }
}
