package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ARN, Name}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateBulkImportJobRequest(
    jobName: Name,
    jobRoleArn: ARN,
    files: Iterable[zio.aws.iotsitewise.model.File],
    errorReportLocation: zio.aws.iotsitewise.model.ErrorReportLocation,
    jobConfiguration: zio.aws.iotsitewise.model.JobConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.CreateBulkImportJobRequest = {
    import CreateBulkImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.CreateBulkImportJobRequest
      .builder()
      .jobName(Name.unwrap(jobName): java.lang.String)
      .jobRoleArn(ARN.unwrap(jobRoleArn): java.lang.String)
      .files(files.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .errorReportLocation(errorReportLocation.buildAwsValue())
      .jobConfiguration(jobConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.CreateBulkImportJobRequest.ReadOnly =
    zio.aws.iotsitewise.model.CreateBulkImportJobRequest.wrap(buildAwsValue())
}
object CreateBulkImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.CreateBulkImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.CreateBulkImportJobRequest =
      zio.aws.iotsitewise.model.CreateBulkImportJobRequest(
        jobName,
        jobRoleArn,
        files.map { item =>
          item.asEditable
        },
        errorReportLocation.asEditable,
        jobConfiguration.asEditable
      )
    def jobName: Name
    def jobRoleArn: ARN
    def files: List[zio.aws.iotsitewise.model.File.ReadOnly]
    def errorReportLocation
        : zio.aws.iotsitewise.model.ErrorReportLocation.ReadOnly
    def jobConfiguration: zio.aws.iotsitewise.model.JobConfiguration.ReadOnly
    def getJobName: ZIO[Any, Nothing, Name] = ZIO.succeed(jobName)
    def getJobRoleArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(jobRoleArn)
    def getFiles
        : ZIO[Any, Nothing, List[zio.aws.iotsitewise.model.File.ReadOnly]] =
      ZIO.succeed(files)
    def getErrorReportLocation: ZIO[
      Any,
      Nothing,
      zio.aws.iotsitewise.model.ErrorReportLocation.ReadOnly
    ] = ZIO.succeed(errorReportLocation)
    def getJobConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.iotsitewise.model.JobConfiguration.ReadOnly
    ] = ZIO.succeed(jobConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateBulkImportJobRequest
  ) extends zio.aws.iotsitewise.model.CreateBulkImportJobRequest.ReadOnly {
    override val jobName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.jobName())
    override val jobRoleArn: ARN =
      zio.aws.iotsitewise.model.primitives.ARN(impl.jobRoleArn())
    override val files: List[zio.aws.iotsitewise.model.File.ReadOnly] = impl
      .files()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.File.wrap(item)
      }
      .toList
    override val errorReportLocation
        : zio.aws.iotsitewise.model.ErrorReportLocation.ReadOnly =
      zio.aws.iotsitewise.model.ErrorReportLocation
        .wrap(impl.errorReportLocation())
    override val jobConfiguration
        : zio.aws.iotsitewise.model.JobConfiguration.ReadOnly =
      zio.aws.iotsitewise.model.JobConfiguration.wrap(impl.jobConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateBulkImportJobRequest
  ): zio.aws.iotsitewise.model.CreateBulkImportJobRequest.ReadOnly =
    new Wrapper(impl)
}
