package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{EntryId, ErrorMessage}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchGetAssetPropertyValueHistoryErrorEntry(
    errorCode: zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode,
    errorMessage: ErrorMessage,
    entryId: EntryId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorEntry = {
    import BatchGetAssetPropertyValueHistoryErrorEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorEntry
      .builder()
      .errorCode(errorCode.unwrap)
      .errorMessage(ErrorMessage.unwrap(errorMessage): java.lang.String)
      .entryId(EntryId.unwrap(entryId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorEntry.ReadOnly =
    zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorEntry
      .wrap(buildAwsValue())
}
object BatchGetAssetPropertyValueHistoryErrorEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorEntry =
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorEntry(
        errorCode,
        errorMessage,
        entryId
      )
    def errorCode
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode
    def errorMessage: ErrorMessage
    def entryId: EntryId
    def getErrorCode: ZIO[
      Any,
      Nothing,
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode
    ] = ZIO.succeed(errorCode)
    def getErrorMessage: ZIO[Any, Nothing, ErrorMessage] =
      ZIO.succeed(errorMessage)
    def getEntryId: ZIO[Any, Nothing, EntryId] = ZIO.succeed(entryId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorEntry
  ) extends zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorEntry.ReadOnly {
    override val errorCode
        : zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode =
      zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorCode
        .wrap(impl.errorCode())
    override val errorMessage: ErrorMessage =
      zio.aws.iotsitewise.model.primitives.ErrorMessage(impl.errorMessage())
    override val entryId: EntryId =
      zio.aws.iotsitewise.model.primitives.EntryId(impl.entryId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorEntry
  ): zio.aws.iotsitewise.model.BatchGetAssetPropertyValueHistoryErrorEntry.ReadOnly =
    new Wrapper(impl)
}
