package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.Expression
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Metric(
    expression: Expression,
    variables: Iterable[zio.aws.iotsitewise.model.ExpressionVariable],
    window: zio.aws.iotsitewise.model.MetricWindow,
    processingConfig: Optional[
      zio.aws.iotsitewise.model.MetricProcessingConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.Metric = {
    import Metric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.Metric
      .builder()
      .expression(Expression.unwrap(expression): java.lang.String)
      .variables(variables.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .window(window.buildAwsValue())
      .optionallyWith(processingConfig.map(value => value.buildAwsValue()))(
        _.processingConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.Metric.ReadOnly =
    zio.aws.iotsitewise.model.Metric.wrap(buildAwsValue())
}
object Metric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.Metric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.Metric =
      zio.aws.iotsitewise.model.Metric(
        expression,
        variables.map { item =>
          item.asEditable
        },
        window.asEditable,
        processingConfig.map(value => value.asEditable)
      )
    def expression: Expression
    def variables: List[zio.aws.iotsitewise.model.ExpressionVariable.ReadOnly]
    def window: zio.aws.iotsitewise.model.MetricWindow.ReadOnly
    def processingConfig
        : Optional[zio.aws.iotsitewise.model.MetricProcessingConfig.ReadOnly]
    def getExpression: ZIO[Any, Nothing, Expression] = ZIO.succeed(expression)
    def getVariables: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.ExpressionVariable.ReadOnly
    ]] = ZIO.succeed(variables)
    def getWindow
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.MetricWindow.ReadOnly] =
      ZIO.succeed(window)
    def getProcessingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.MetricProcessingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("processingConfig", processingConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.Metric
  ) extends zio.aws.iotsitewise.model.Metric.ReadOnly {
    override val expression: Expression =
      zio.aws.iotsitewise.model.primitives.Expression(impl.expression())
    override val variables
        : List[zio.aws.iotsitewise.model.ExpressionVariable.ReadOnly] = impl
      .variables()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.ExpressionVariable.wrap(item)
      }
      .toList
    override val window: zio.aws.iotsitewise.model.MetricWindow.ReadOnly =
      zio.aws.iotsitewise.model.MetricWindow.wrap(impl.window())
    override val processingConfig
        : Optional[zio.aws.iotsitewise.model.MetricProcessingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingConfig())
        .map(value =>
          zio.aws.iotsitewise.model.MetricProcessingConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.Metric
  ): zio.aws.iotsitewise.model.Metric.ReadOnly = new Wrapper(impl)
}
