package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPortalsResponse(
    portalSummaries: Optional[
      Iterable[zio.aws.iotsitewise.model.PortalSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListPortalsResponse = {
    import ListPortalsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListPortalsResponse
      .builder()
      .optionallyWith(
        portalSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portalSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ListPortalsResponse.ReadOnly =
    zio.aws.iotsitewise.model.ListPortalsResponse.wrap(buildAwsValue())
}
object ListPortalsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListPortalsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListPortalsResponse =
      zio.aws.iotsitewise.model.ListPortalsResponse(
        portalSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def portalSummaries
        : Optional[List[zio.aws.iotsitewise.model.PortalSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getPortalSummaries: ZIO[Any, AwsError, List[
      zio.aws.iotsitewise.model.PortalSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("portalSummaries", portalSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListPortalsResponse
  ) extends zio.aws.iotsitewise.model.ListPortalsResponse.ReadOnly {
    override val portalSummaries
        : Optional[List[zio.aws.iotsitewise.model.PortalSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portalSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotsitewise.model.PortalSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListPortalsResponse
  ): zio.aws.iotsitewise.model.ListPortalsResponse.ReadOnly = new Wrapper(impl)
}
